/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import java.util.Arrays;

public class Point {
    private final double[] array;
    private String toString;
    private static final Point DEFAULT = new Point(0);

    private Point(double[] array) {
        this(array.length);
        System.arraycopy(array, 0, this.array, 0, this.array.length);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
            if (i >= array.length - 1) continue;
            builder.append(",");
        }
        this.toString = builder.append("]").toString();
    }

    private Point(int dimension) {
        this.array = new double[dimension];
    }

    public static final Point at(double ... array) {
        return new Point(array);
    }

    public static final Point random(int dimension) {
        return Point.random(dimension, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static final Point random(int dimension, double min, double max) {
        double[] array = new double[dimension];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.random() * (max - min) + min;
        }
        return new Point(array);
    }

    public static final Point getDefault() {
        return DEFAULT;
    }

    public double[] toArray() {
        double[] copy = new double[this.array.length];
        System.arraycopy(this.array, 0, copy, 0, copy.length);
        return copy;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.array);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return Arrays.equals(this.array, other.array);
    }

    public int[] toIntArray() {
        int[] res = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            res[i] = (int)Math.round(this.array[i]);
        }
        return res;
    }

    public String toLogString() {
        return this.toString.replaceAll("\\[|\\]", "").replace(",", "\t");
    }
}

