/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cluster;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.seninp.jmotif.cluster.StartStrategy;
import net.seninp.jmotif.text.CosineDistanceMatrix;
import net.seninp.jmotif.text.TextProcessor;
import org.slf4j.LoggerFactory;

public class TextKMeans {
    private static final double THRESHOLD = 1.0E-9;
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;
    private static final TextProcessor tp;

    public static HashMap<String, List<String>> cluster(HashMap<String, HashMap<String, Double>> tfidf, Integer clustersNum, StartStrategy strategy) {
        consoleLogger.info("starting KMeans with " + clustersNum + " centers.");
        LinkedHashMap<String, HashMap<String, Double>> centroids = strategy.getCentroids(clustersNum, tfidf);
        HashMap<String, List<String>> clusters = TextKMeans.clusterize(centroids, tfidf);
        System.out.println(clusters.toString().replace("],", "],\n"));
        while (TextKMeans.updateCentroids(centroids, clusters, tfidf)) {
            clusters = TextKMeans.clusterize(centroids, tfidf);
            System.out.println(clusters.toString().replace("],", "],\n"));
        }
        System.out.println(TextKMeans.centroidsToString(centroids));
        System.out.println(clusters.toString().replace("],", "],\n"));
        CosineDistanceMatrix m = new CosineDistanceMatrix(centroids);
        System.out.println(m.toString());
        double intraSS = TextKMeans.computeIntraSS(tfidf, clusters);
        System.out.println("Objective function: " + intraSS + "\n\n");
        System.out.println(clusters.toString().replace("],", "],\n"));
        System.out.println("Objective function: " + intraSS + "\n\n");
        return clusters;
    }

    private static char[] centroidsToString(LinkedHashMap<String, HashMap<String, Double>> centroids) {
        return tp.tfidfToTable(centroids).toCharArray();
    }

    private static double computeIntraSS(HashMap<String, HashMap<String, Double>> tfidf, HashMap<String, List<String>> clusters) {
        double res = 0.0;
        for (Map.Entry<String, List<String>> e : clusters.entrySet()) {
            for (int i = 0; i < e.getValue().size(); ++i) {
                for (int j = i + 1; j < e.getValue().size(); ++j) {
                    String key1 = e.getValue().get(i);
                    String key2 = e.getValue().get(j);
                    res += tp.cosineDistance(tfidf.get(key1), tfidf.get(key2));
                }
            }
        }
        return res;
    }

    private static boolean updateCentroids(LinkedHashMap<String, HashMap<String, Double>> centroids, HashMap<String, List<String>> clusters, HashMap<String, HashMap<String, Double>> tfidf) {
        boolean res = false;
        for (Map.Entry<String, List<String>> cluster : clusters.entrySet()) {
            HashMap<String, Double> newCentroid = TextKMeans.computeCentroid(tfidf, cluster.getValue());
            double dist = tp.cosineDistance(newCentroid, centroids.get(cluster.getKey()));
            if (!(1.0 - dist > 1.0E-9)) continue;
            res = true;
            centroids.put(cluster.getKey(), newCentroid);
        }
        return res;
    }

    public static HashMap<String, Double> computeCentroid(HashMap<String, HashMap<String, Double>> tfidf, List<String> members) {
        ArrayList<String> words = new ArrayList<String>();
        for (String word : tfidf.entrySet().iterator().next().getValue().keySet()) {
            words.add(word.substring(0));
        }
        HashMap<String, Double> res = new HashMap<String, Double>();
        for (String word : words) {
            double sum = 0.0;
            for (String bagKey : members) {
                sum += tfidf.get(bagKey).get(word).doubleValue();
            }
            res.put(word, sum / (double)members.size());
        }
        return tp.normalizeToUnitVector(res);
    }

    private static HashMap<String, List<String>> clusterize(LinkedHashMap<String, HashMap<String, Double>> centroids, HashMap<String, HashMap<String, Double>> tfidf) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (String string : centroids.keySet()) {
            res.put(string.substring(0), new ArrayList());
        }
        for (Map.Entry entry : tfidf.entrySet()) {
            String centroidKey = "";
            double minDist = -1.0;
            for (Map.Entry<String, HashMap<String, Double>> centroid : centroids.entrySet()) {
                double dist = tp.cosineDistance(centroid.getValue(), (HashMap)entry.getValue());
                if (!(dist > minDist)) continue;
                centroidKey = centroid.getKey();
                minDist = dist;
            }
            ((List)res.get(centroidKey)).add(entry.getKey());
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : res.entrySet()) {
            sb.append((String)e.getKey()).append(": ").append(TextKMeans.list2String((List)e.getValue())).append(", ");
        }
        consoleLogger.info("clusterizaton run finished, clusters: " + sb.toString());
        return res;
    }

    private static String list2String(List<String> value) {
        StringBuffer sb = new StringBuffer("[");
        for (String str : value) {
            sb.append(str).append(",");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.append("]").toString();
    }

    static {
        LOGGING_LEVEL = Level.INFO;
        tp = new TextProcessor();
        consoleLogger = (Logger)LoggerFactory.getLogger(TextKMeans.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

