/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import net.seninp.jmotif.cluster.Cluster;
import net.seninp.jmotif.cluster.LinkageCriterion;
import net.seninp.jmotif.text.CosineDistanceMatrix;

public class HC {
    public static Cluster Hc(HashMap<String, HashMap<String, Double>> tfidfData, LinkageCriterion criterion) {
        CosineDistanceMatrix distanceMatrix = new CosineDistanceMatrix(tfidfData);
        distanceMatrix.transformForHC();
        ArrayList<Cluster> activeClusters = new ArrayList<Cluster>();
        for (String key : tfidfData.keySet()) {
            Cluster c = new Cluster(key);
            activeClusters.add(c);
        }
        Stack<Cluster> stack = new Stack<Cluster>();
        while (activeClusters.size() > 1) {
            Cluster top;
            Cluster nearest;
            if (stack.isEmpty()) {
                Cluster cc = (Cluster)activeClusters.get(0);
                stack.push(cc);
            }
            if (stack.contains(nearest = HC.getNearest(top = (Cluster)stack.peek(), activeClusters, tfidfData, distanceMatrix, criterion))) {
                Cluster a = (Cluster)stack.pop();
                Cluster b = (Cluster)stack.pop();
                activeClusters.remove(a);
                activeClusters.remove(b);
                Cluster merged = new Cluster();
                merged.merge(a, b, a.distanceTo(b, tfidfData, distanceMatrix, criterion));
                activeClusters.add(merged);
                continue;
            }
            stack.push(nearest);
        }
        Cluster res = (Cluster)activeClusters.get(0);
        return res;
    }

    private static Cluster getNearest(Cluster stackTop, List<Cluster> activeClusters, HashMap<String, HashMap<String, Double>> data, CosineDistanceMatrix distanceMatrix, LinkageCriterion criterion) {
        Cluster res = null;
        double minDistance = Double.MAX_VALUE;
        for (Cluster cc : activeClusters) {
            Double distance;
            if (stackTop.equals(cc) || !((distance = stackTop.distanceTo(cc, data, distanceMatrix, criterion)) < minDistance)) continue;
            res = cc;
            minDistance = distance;
        }
        return res;
    }
}

