/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cluster;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import net.seninp.jmotif.cluster.StartStrategy;
import net.seninp.jmotif.text.CosineDistanceMatrix;

public class FurthestFirstStrategy
implements StartStrategy {
    @Override
    public LinkedHashMap<String, HashMap<String, Double>> getCentroids(Integer num, HashMap<String, HashMap<String, Double>> data) {
        Random random = new Random();
        CosineDistanceMatrix matrix = new CosineDistanceMatrix(data);
        TreeSet<String> keys = new TreeSet<String>();
        TreeSet<String> resultKeys = new TreeSet<String>();
        for (String k : data.keySet()) {
            keys.add(k.substring(0));
        }
        int rand = random.nextInt(keys.size());
        String center1 = matrix.getRows()[rand];
        resultKeys.add(center1);
        while (resultKeys.size() < num) {
            double maxDist = 0.0;
            String furthestElement = null;
            for (String k : keys) {
                if (resultKeys.contains(k)) continue;
                if (null == furthestElement) {
                    furthestElement = k;
                    maxDist = this.minCosineDistance(furthestElement, resultKeys, matrix);
                    continue;
                }
                if (!(maxDist > this.minCosineDistance(k, resultKeys, matrix))) continue;
                furthestElement = k;
                maxDist = this.minCosineDistance(furthestElement, resultKeys, matrix);
            }
            resultKeys.add(furthestElement);
        }
        LinkedHashMap<String, HashMap<String, Double>> res = new LinkedHashMap<String, HashMap<String, Double>>();
        int counter = 0;
        for (String key : resultKeys) {
            HashMap<String, Double> value = new HashMap<String, Double>();
            for (Map.Entry<String, Double> e : data.get(key).entrySet()) {
                value.put(e.getKey().substring(0), e.getValue());
            }
            res.put(String.valueOf(counter), value);
            ++counter;
        }
        return res;
    }

    private double minCosineDistance(String furthestElement, TreeSet<String> resultKeys, CosineDistanceMatrix matrix) {
        double minDist = 0.0;
        for (String currKey : resultKeys) {
            if (!(matrix.distanceBetween(currKey, furthestElement) > minDist)) continue;
            minDist = matrix.distanceBetween(currKey, furthestElement);
        }
        return minDist;
    }
}

