/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cluster;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import net.seninp.jmotif.cluster.LinkageCriterion;
import net.seninp.jmotif.text.CosineDistanceMatrix;

public class Cluster {
    public Cluster left = null;
    public Cluster right = null;
    public int level;
    public double distanceBetween;
    private TreeSet<String> keys;

    public Cluster() {
    }

    public Cluster(String key) {
        this.keys = new TreeSet();
        this.keys.add(key);
    }

    public void merge(Cluster left, Cluster right, Double distance) {
        this.left = left;
        this.right = right;
        this.keys = new TreeSet();
        this.keys.addAll(left.keys);
        this.keys.addAll(right.keys);
        this.distanceBetween = distance;
    }

    public Double distanceTo(Cluster otherCluster, HashMap<String, HashMap<String, Double>> data, CosineDistanceMatrix distanceMatrix, LinkageCriterion criterion) {
        if (otherCluster.keys.size() == 1 && this.keys.size() == 1) {
            return distanceMatrix.distanceBetween(otherCluster.keys.first(), this.keys.first());
        }
        if (criterion.equals((Object)LinkageCriterion.SINGLE)) {
            double minDist = Double.MAX_VALUE;
            for (String keyA : this.keys) {
                for (String keyB : otherCluster.keys) {
                    Double dist = distanceMatrix.distanceBetween(keyA, keyB);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                }
            }
            return minDist;
        }
        if (criterion.equals((Object)LinkageCriterion.COMPLETE)) {
            double maxDist = Double.MIN_VALUE;
            for (String keyA : this.keys) {
                for (String keyB : otherCluster.keys) {
                    Double dist = distanceMatrix.distanceBetween(keyA, keyB);
                    if (!(dist > maxDist)) continue;
                    maxDist = dist;
                }
            }
            return maxDist;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }

    public String toString() {
        return Arrays.toString(this.keys.toArray());
    }

    public String toNewick() {
        StringBuilder sb = new StringBuilder();
        if (null != this.left && null != this.right) {
            double height = 0.0;
            height = this.left.isTerminal() && !this.right.isTerminal() ? Math.abs(this.distanceBetween - this.right.distanceBetween) : (!this.left.isTerminal() && this.right.isTerminal() ? Math.abs(this.distanceBetween - this.left.distanceBetween) : this.distanceBetween);
            height /= 2.0;
            if (this.left.isTerminal()) {
                sb.append(this.left.toNewick()).append(":").append(String.valueOf(height));
            } else {
                sb.append("(").append(this.left.toNewick()).append(")").append(":").append(String.valueOf(height));
            }
            sb.append(",");
            if (this.right.isTerminal()) {
                sb.append(this.right.toNewick()).append(":").append(this.formatNumber(height));
            } else {
                sb.append("(").append(this.right.toNewick()).append(")").append(":").append(this.formatNumber(height));
            }
            return sb.toString();
        }
        return this.keys.first();
    }

    private String formatNumber(double number) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.##########", symbols);
        return format.format(number);
    }

    public boolean isTerminal() {
        return null == this.left && null == this.right;
    }
}

