/*
 * Decompiled with CFR 0.152.
 */
package net.seidengarn.keepasshttp.client;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.seidengarn.json.JSONParser;
import net.seidengarn.keepasshttp.client.EncryptionUtil;
import net.seidengarn.keepasshttp.client.KeePassLogin;
import net.seidengarn.keepasshttp.client.exception.EncryptionException;
import net.seidengarn.keepasshttp.client.exception.KeePassHttpCommunicationException;
import net.seidengarn.keepasshttp.client.exception.KeePassHttpException;
import net.seidengarn.keepasshttp.client.exception.KeePassHttpNotAssociatedException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;

public class KeePassHttpConnector {
    private static final Logger LOG = Logger.getLogger(KeePassHttpConnector.class.getName());
    private int port = 19455;
    private final File keyFile;
    private String id;
    private String key;

    public KeePassHttpConnector() {
        this.keyFile = new File(FileUtils.getUserDirectory(), "keepasshttpclient.json");
        this.loadKey();
    }

    public KeePassHttpConnector(int port) {
        this();
        this.port = port;
    }

    public KeePassHttpConnector(String id, String key) {
        this.id = id;
        this.key = key;
        this.keyFile = null;
    }

    public List<KeePassLogin> getLogins(String url, String submitUrl) throws KeePassHttpException {
        try {
            try {
                this.testAssociate();
            }
            catch (KeePassHttpNotAssociatedException e) {
                LOG.info("KeePass is not associated, try to associate");
                this.associate();
            }
            if (url == null) {
                throw new KeePassHttpException("missing parameter url");
            }
            if (submitUrl == null) {
                submitUrl = url;
            }
            String iv = this.generateIv();
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("RequestType", "get-logins");
            map.put("Id", this.id);
            map.put("Nonce", iv);
            map.put("Verifier", Base64.getEncoder().encodeToString(EncryptionUtil.encrypt(iv, iv, this.key)));
            map.put("Url", Base64.getEncoder().encodeToString(EncryptionUtil.encrypt(url, iv, this.key)));
            map.put("SubmitUrl", Base64.getEncoder().encodeToString(EncryptionUtil.encrypt(submitUrl, iv, this.key)));
            map = this.communicate(map);
            iv = (String)map.get("Nonce");
            ArrayList<KeePassLogin> loginList = new ArrayList<KeePassLogin>();
            List entries = (List)map.get("Entries");
            for (Object entryObject : entries) {
                Map entryMap = (Map)entryObject;
                KeePassLogin login = new KeePassLogin();
                login.setName(EncryptionUtil.decrypt(Base64.getDecoder().decode((String)entryMap.get("Name")), iv, this.key));
                login.setLogin(EncryptionUtil.decrypt(Base64.getDecoder().decode((String)entryMap.get("Login")), iv, this.key));
                login.setPassword(EncryptionUtil.decrypt(Base64.getDecoder().decode((String)entryMap.get("Password")), iv, this.key));
                loginList.add(login);
            }
            return loginList;
        }
        catch (EncryptionException e) {
            throw new KeePassHttpCommunicationException("Communication with KeePass failed", e);
        }
    }

    public KeePassLogin getLogin(String url) throws KeePassHttpException {
        List<KeePassLogin> logins = this.getLogins(url, url);
        if (logins == null || logins.isEmpty()) {
            throw new KeePassHttpException("Login for URL " + url + " not found");
        }
        if (logins.size() > 1) {
            throw new KeePassHttpException("More than one login for URL " + url + " found.");
        }
        return logins.get(0);
    }

    private void loadKey() {
        if (this.keyFile != null) {
            try {
                String data = FileUtils.readFileToString((File)this.keyFile, (Charset)StandardCharsets.UTF_8);
                Map map = (Map)JSONParser.parse((String)data);
                this.id = (String)map.get("Id");
                this.key = (String)map.get("Key");
            }
            catch (IOException e) {
                LOG.warning("key could not be loaded");
            }
        }
    }

    private void storeKey() throws KeePassHttpException {
        if (this.keyFile != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Key", this.key);
                map.put("Id", this.id);
                String data = JSONParser.compose(map);
                FileUtils.writeStringToFile((File)this.keyFile, (String)data, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new KeePassHttpException("Exception while storing the key to communicate with KeePass", e);
            }
        }
    }

    void testAssociate() throws KeePassHttpException {
        if (this.id == null || this.key == null) {
            this.associate();
        }
        try {
            String iv = this.generateIv();
            String verifier = Base64.getEncoder().encodeToString(EncryptionUtil.encrypt(iv, iv, this.key));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RequestType", "test-associate");
            map.put("Id", this.id);
            map.put("Nonce", iv);
            map.put("Verifier", verifier);
            this.communicate(map);
        }
        catch (EncryptionException e) {
            throw new KeePassHttpCommunicationException("Communication with KeePass failed", e);
        }
    }

    private Map<String, Object> communicate(Map<String, Object> map) throws KeePassHttpCommunicationException, KeePassHttpNotAssociatedException {
        Map responseMap;
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create("http://localhost:" + this.port)).POST(HttpRequest.BodyPublishers.ofString(JSONParser.compose(map))).build();
            HttpResponse<String> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                throw new KeePassHttpCommunicationException("Communication with KeePass failed, http-returncode is " + httpResponse.statusCode() + ", expected 200");
            }
            responseMap = (Map)JSONParser.parse((String)httpResponse.body());
            if (responseMap == null || responseMap.get("Success") == null) {
                throw new KeePassHttpCommunicationException("Communication with KeePass failed, response from KeePassHttp is invalid");
            }
            if (!responseMap.get("Success").equals("true")) {
                throw new KeePassHttpNotAssociatedException("Communication with KeePass failed, client is not associated with KeePassHttp");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new KeePassHttpCommunicationException("Communication with KeePass failed", e);
        }
        return responseMap;
    }

    private String generateIv() {
        byte[] ivArr = new byte[16];
        for (int i = 0; i < ivArr.length; ++i) {
            ivArr[i] = (byte)RandomUtils.nextInt();
        }
        return Base64.getEncoder().encodeToString(ivArr);
    }

    void associate() throws KeePassHttpException {
        if (this.key == null) {
            this.key = this.generateIv();
        }
        try {
            String iv = this.generateIv();
            String verifier = Base64.getEncoder().encodeToString(EncryptionUtil.encrypt(iv, iv, this.key));
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("RequestType", "associate");
            map.put("Key", this.key);
            map.put("Nonce", iv);
            map.put("Verifier", verifier);
            map = this.communicate(map);
            this.id = (String)map.get("Id");
            this.storeKey();
        }
        catch (EncryptionException e) {
            throw new KeePassHttpCommunicationException("Communication with KeePass failed", e);
        }
    }
}

