/*
 * Decompiled with CFR 0.152.
 */
package net.seesharpsoft.spring.multipart.boot.demo.controller;

import net.seesharpsoft.spring.multipart.boot.demo.entity.Person;
import net.seesharpsoft.spring.multipart.boot.demo.repository.PersonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
public class ProtectedController {
    @Autowired
    private PersonRepository repository;

    @RequestMapping(value={"/secured"}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String secured() {
        this.repository.saveAndFlush(new Person());
        return "SECURE! There are " + this.repository.count() + " persons in the database!";
    }

    @RequestMapping(value={"/add"}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('ROLE_BASIC')")
    public String add() {
        this.repository.saveAndFlush(new Person());
        return "Add! There are " + this.repository.count() + " persons in the database!";
    }
}

