/*
 * Decompiled with CFR 0.152.
 */
package net.secodo.jcircuitbreaker.breakstrategy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutedTask;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.util.TimeUtil;

public class TooLongCurrentAverageExecutionTimeStrategy
implements BreakStrategy {
    protected float maxAllowedExecutionTimeMillis;
    protected float percentageOfMaxTimesToSkip;
    private final TimeUtil timeUtil;

    public TooLongCurrentAverageExecutionTimeStrategy(long maxAllowedAverageExecutionTimeMillis, int percentageOfLongestTimesToSkip) {
        this.maxAllowedExecutionTimeMillis = maxAllowedAverageExecutionTimeMillis;
        this.timeUtil = new TimeUtil();
        this.percentageOfMaxTimesToSkip = percentageOfLongestTimesToSkip >= 0 && percentageOfLongestTimesToSkip <= 100 ? 0.01f * (float)percentageOfLongestTimesToSkip : 0.0f;
    }

    public TooLongCurrentAverageExecutionTimeStrategy(long maxAllowedExecutionTimeMilis) {
        this(maxAllowedExecutionTimeMilis, 0);
    }

    @Override
    public boolean shouldBreak(ExecutionContext executionContext) {
        Collection<ExecutedTask> executionsInProgress = executionContext.getExecutionsInProgress();
        if (executionsInProgress.isEmpty()) {
            return false;
        }
        List startTimestamps = executionsInProgress.stream().map(ExecutedTask::getExecutionStaredTimestamp).collect(Collectors.toList());
        Collections.sort(startTimestamps);
        List interestingTimestamps = startTimestamps.subList(0, (int)((1.0f - this.percentageOfMaxTimesToSkip) * (float)startTimestamps.size()));
        if (interestingTimestamps.isEmpty()) {
            return false;
        }
        long currentTime = this.timeUtil.getCurrentTimeMilis();
        Long sumOfInterestingTimestamps = interestingTimestamps.stream().mapToLong(t -> currentTime - t).sum();
        float currentAverageExecutionTime = (float)sumOfInterestingTimestamps.longValue() / (float)interestingTimestamps.size();
        return currentAverageExecutionTime > this.maxAllowedExecutionTimeMillis;
    }
}

