/*
 * Decompiled with CFR 0.152.
 */
package net.secodo.jcircuitbreaker.breakhandler.impl;

import java.util.concurrent.Callable;
import net.secodo.jcircuitbreaker.CircuitBreakerException;
import net.secodo.jcircuitbreaker.breaker.CircuitBreaker;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import net.secodo.jcircuitbreaker.breakhandler.BreakHandler;
import net.secodo.jcircuitbreaker.breakhandler.BreakHandlerException;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;

public class RetryHandler<R>
implements BreakHandler<R> {
    private final int maxNumberOfRetries;
    private int currentNumberOfRetries;

    public RetryHandler() {
        this(1);
    }

    public RetryHandler(int maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    @Override
    public R onBreak(CircuitBreaker circuitBreaker, Callable<R> task, BreakStrategy breakStrategy, ExecutionContext<?> executionContext) throws BreakHandlerException {
        if (this.currentNumberOfRetries == this.maxNumberOfRetries) {
            throw new BreakHandlerException("Number of retries reached maximum. Unable to execute the task: " + task + ". Max number of retries was: " + this.maxNumberOfRetries);
        }
        ++this.currentNumberOfRetries;
        try {
            return circuitBreaker.execute(task, breakStrategy, this, executionContext);
        }
        catch (CircuitBreakerException e) {
            throw new BreakHandlerException(RetryHandler.class.getSimpleName() + " was able to retry the task, but the task execution resulted in exception. Task: " + task, e);
        }
    }

    public int getCurrentNumberOfRetries() {
        return this.currentNumberOfRetries;
    }
}

