/*
 * Decompiled with CFR 0.152.
 */
package net.secodo.jcircuitbreaker.breaker.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.secodo.jcircuitbreaker.CircuitBreakerException;
import net.secodo.jcircuitbreaker.breaker.CircuitBreaker;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutedTask;
import net.secodo.jcircuitbreaker.breaker.execution.impl.DefaultExecutionContextImpl;
import net.secodo.jcircuitbreaker.breakhandler.BreakHandler;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.util.TimeUtil;

public class DefaultCircuitBreaker
implements CircuitBreaker {
    private final ConcurrentHashMap<String, ExecutedTask> tasksInProgress;
    private final TimeUtil timeUtil;

    public DefaultCircuitBreaker(int predictedConcurrencyLevel) {
        this.tasksInProgress = new ConcurrentHashMap(predictedConcurrencyLevel + 1, 0.75f, predictedConcurrencyLevel);
        this.timeUtil = new TimeUtil();
    }

    public DefaultCircuitBreaker() {
        this.tasksInProgress = new ConcurrentHashMap();
        this.timeUtil = new TimeUtil();
    }

    @Override
    public <R> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler) throws CircuitBreakerException {
        return this.execute(task, breakStrategy, breakHandler, null);
    }

    @Override
    public <R, U> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler, U userData) throws CircuitBreakerException {
        DefaultExecutionContextImpl<U> context = new DefaultExecutionContextImpl<U>(this.tasksInProgress, userData);
        if (!breakStrategy.shouldBreak(context)) {
            ExecutedTask<R> executedTask = new ExecutedTask<R>(task, this.timeUtil.getCurrentTimeMilis());
            String taskKey = String.valueOf(Thread.currentThread().getId()) + "_" + task.hashCode();
            R returnedValue = null;
            try {
                this.tasksInProgress.put(taskKey, executedTask);
                returnedValue = task.call();
            }
            catch (Exception e) {
                throw new CircuitBreakerException("Exception while executing an actual call to task: " + task, e);
            }
            finally {
                this.tasksInProgress.remove(taskKey);
            }
            return returnedValue;
        }
        return breakHandler.onBreak(this, task, breakStrategy, context);
    }
}

