package net.secodo.jcircuitbreaker.breakstrategy.impl.dsl;

import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;


public class DslOrStrategy implements BreakStrategy {
  private final BreakStrategy strategyA;
  private final BreakStrategy strategyB;

  public DslOrStrategy(BreakStrategy strategyA, BreakStrategy strategyB) {
    this.strategyA = strategyA;
    this.strategyB = strategyB;
  }


  @Override
  public boolean shouldBreak(ExecutionContext executionContext) {
    return strategyA.shouldBreak(executionContext) || strategyB.shouldBreak(executionContext);
  }
}
