package net.secodo.jcircuitbreaker.breakstrategy.impl.dsl;

import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;


public class DslAndStrategy implements BreakStrategy {
  private final BreakStrategy strategyA;
  private final BreakStrategy strategyB;

  public DslAndStrategy(BreakStrategy strategyA, BreakStrategy strategyB) {
    this.strategyA = strategyA;
    this.strategyB = strategyB;
  }


  @Override
  public boolean shouldBreak(ExecutionContext executionContext) {
    return strategyA.shouldBreak(executionContext) && strategyB.shouldBreak(executionContext);
  }
}
