package net.secodo.jcircuitbreaker.breakstrategy.impl;

import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutedTask;
import java.util.Collection;


public class TooManyConcurrentExecutionsStrategy implements BreakStrategy {
  /**
   * Protected access to allow extending classes to dynamically change it,
   * e.g. via MBean
   */
  protected long maxSupportedExecutions;

  public TooManyConcurrentExecutionsStrategy(long maxSupportedExecutions) {
    this.maxSupportedExecutions = maxSupportedExecutions;
  }


  @Override
  public boolean shouldBreak(ExecutionContext executionContext) {
    final Collection<ExecutedTask> executionsInProgress = executionContext.getExecutionsInProgress();

    return executionsInProgress.size() > maxSupportedExecutions;
  }
}
