package net.secodo.jcircuitbreaker.breakstrategy;

import net.secodo.jcircuitbreaker.breakstrategy.impl.dsl.DslAndStrategy;
import net.secodo.jcircuitbreaker.breakstrategy.impl.dsl.DslOrStrategy;


/**
 * DSL builder
 */
public class SimpleStrategyDsl {
  public static BreakStrategy anyOf(BreakStrategy... breakStrategies) {
    BreakStrategy resultingStrategy = breakStrategies[0];


    for (int i = 1; i < breakStrategies.length; i++) {
      resultingStrategy = new DslOrStrategy(resultingStrategy, breakStrategies[i]);
    }

    return resultingStrategy;
  }

  public static BreakStrategy allOf(BreakStrategy... breakStrategies) {
    BreakStrategy resultingStrategy = breakStrategies[0];


    for (int i = 1; i < breakStrategies.length; i++) {
      resultingStrategy = new DslAndStrategy(resultingStrategy, breakStrategies[i]);
    }

    return resultingStrategy;
  }
}
