package net.secodo.jcircuitbreaker.breakhandler;

import net.secodo.jcircuitbreaker.CircuitBreakerException;


/**
 * An exception which can be thrown by implementations of {@link BreakHandler} to indicate that the break can not be handled in sufficient way - particularly meaning that
 * {@link BreakHandler#onBreak(CircuitBreaker, Callable, BreakStrategy, ExecutionContext)} was unable to provide the fallback value.
 *
 */
public class BreakHandlerException extends CircuitBreakerException {
  public BreakHandlerException(String message) {
    super(message);
  }

  public BreakHandlerException(String message, Throwable cause) {
    super(message, cause);
  }
}
