package net.secodo.jcircuitbreaker.breakhandler;

import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.breaker.CircuitBreaker;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import java.util.concurrent.Callable;


/**
 * Handles break situation. Can result in different actions to be performed like trying to retry the task or return static fallback value instead.
 *
 *
 * @param <R> the return type of onBreak method. This must be the same return type as the of of executed Task
 */
public interface BreakHandler<R> {
  /**
   * Handles situation when break occurs. Returns the fallback value in case the break happens.
   *
   * @param circuitBreaker a reference to the {@link CircuitBreaker} which called this break handler
   * @param task the task which execution was prevented by break strategy and resulted in calling this break handler
   * @param breakStrategy the strategy which prevented the execution of task and resulted in calling this break handler
   * @param executionContext contains current execution data (specific to current execution)
   * @return fallback value which replaces the value returned by method call
   *
   * @throws BreakHandlerException in case there was exception while executing this break handler
   */
  R onBreak(CircuitBreaker circuitBreaker, Callable<R> task, BreakStrategy breakStrategy,
            ExecutionContext<?> executionContext) throws BreakHandlerException;

}
