package net.secodo.jcircuitbreaker.breaker.impl;

import net.secodo.jcircuitbreaker.CircuitBreakerException;
import net.secodo.jcircuitbreaker.breakhandler.BreakHandler;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import java.util.concurrent.Callable;


public class FixedCircuitBreaker<R> extends DefaultCircuitBreaker {
  private final BreakStrategy breakStrategy;
  private final BreakHandler<R> breakHandler;

  public FixedCircuitBreaker(BreakStrategy breakStrategy, BreakHandler<R> breakHandler) {
    this.breakStrategy = breakStrategy;
    this.breakHandler = breakHandler;
  }

  public R execute(Callable<R> task) throws CircuitBreakerException {
    return super.execute(task, breakStrategy, breakHandler);
  }

  public <U> R execute(Callable<R> task, U userData) throws CircuitBreakerException {
    return super.execute(task, breakStrategy, breakHandler, userData);
  }
}
