package net.secodo.jcircuitbreaker.breaker.impl;

import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.util.TimeUtil;
import net.secodo.jcircuitbreaker.CircuitBreakerException;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import net.secodo.jcircuitbreaker.breaker.execution.impl.DefaultExecutionContextImpl;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutedTask;
import net.secodo.jcircuitbreaker.breakhandler.BreakHandler;
import net.secodo.jcircuitbreaker.breaker.CircuitBreaker;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;


public class DefaultCircuitBreaker implements CircuitBreaker {
  private final ConcurrentHashMap<String, ExecutedTask> tasksInProgress;
  private final TimeUtil timeUtil;

  public DefaultCircuitBreaker(int predictedConcurrencyLevel) {
    this.tasksInProgress = new ConcurrentHashMap<>(predictedConcurrencyLevel + 1, 0.75f, predictedConcurrencyLevel);
    timeUtil = new TimeUtil();
  }

  public DefaultCircuitBreaker() {
    this.tasksInProgress = new ConcurrentHashMap<>();
    timeUtil = new TimeUtil();
  }

  @Override
  public <R> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler)
                throws CircuitBreakerException {
    return execute(task, breakStrategy, breakHandler, null);
  }

  @Override
  public <R, U> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler,
                          U userData) throws CircuitBreakerException {
    ExecutionContext context = new DefaultExecutionContextImpl(tasksInProgress, userData);


    if (!breakStrategy.shouldBreak(context)) {
      // track state asynchronously - not to block by resize operation on possible resize of hashmap


      final ExecutedTask executedTask = new ExecutedTask(task, timeUtil.getCurrentTimeMilis());
      final String taskKey = String.valueOf(Thread.currentThread().getId()) + "_" + task.hashCode();

      /** TODO: consider running as {@link java.util.concurrent.FutureTask} - allows to cancel the task if it takes too long */
      R returnedValue = null;
      try {
        tasksInProgress.put(taskKey, executedTask);

        returnedValue = task.call();

      } catch (Exception e) {
        throw new CircuitBreakerException("Exception while executing an actual call to task: " + task, e);

      } finally {
        tasksInProgress.remove(taskKey);
      }


      return returnedValue;

    } else {
      return breakHandler.onBreak(this, task, breakStrategy, context);
    }

  }


}
