package net.secodo.jcircuitbreaker.breaker.execution.impl;

import net.secodo.jcircuitbreaker.breaker.execution.ExecutedTask;
import net.secodo.jcircuitbreaker.breaker.execution.ExecutionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;


public class DefaultExecutionContextImpl<U> implements ExecutionContext<U> {
  private final ConcurrentHashMap<String, ExecutedTask> tasksInProgress;
  private final U userData;

  public DefaultExecutionContextImpl(ConcurrentHashMap<String, ExecutedTask> tasksInProgress, U userData) {
    this.tasksInProgress = tasksInProgress;
    this.userData = userData;
  }


  @Override
  public Collection<ExecutedTask> getExecutionsInProgress() {
    return Collections.unmodifiableCollection(tasksInProgress.values());
  }

  @Override
  public U getUserData() {
    return userData;
  }
}
