package net.secodo.jcircuitbreaker.breaker.execution;

import java.util.Objects;
import java.util.concurrent.Callable;


/**
 * Class that represents single execution of the breaker (in most cases it would mean the execution "in progress")
 */
public class ExecutedTask<R> {
  private final Callable<R> task;
  private final long executionStaredTimestamp;

  public ExecutedTask(Callable<R> task, long executionStaredTimestamp) {
    this.task = task;
    this.executionStaredTimestamp = executionStaredTimestamp;
  }

  public long getExecutionStaredTimestamp() {
    return executionStaredTimestamp;
  }

  public Callable<R> getTask() {
    return task;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if ((o == null) || (getClass() != o.getClass())) {
      return false;
    }

    ExecutedTask<?> that = (ExecutedTask<?>) o;
    return (executionStaredTimestamp == that.executionStaredTimestamp) &&
      Objects.equals(task, that.task);
  }

  @Override
  public int hashCode() {
    return Objects.hash(task);
  }

}
