package net.secodo.jcircuitbreaker;

import net.secodo.jcircuitbreaker.breakhandler.BreakHandler;
import net.secodo.jcircuitbreaker.breakstrategy.BreakStrategy;
import net.secodo.jcircuitbreaker.breaker.impl.DefaultCircuitBreaker;
import java.util.concurrent.Callable;


/**
 * Convenience class providing methods to statically access methods of {@link DefaultCircuitBreaker}
 */
public final class JCircuitBreaker {
  private static DefaultCircuitBreaker defaultCircuitBreakerInstance = new DefaultCircuitBreaker();

  public static <R, U> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler)
                          throws CircuitBreakerException {
    return defaultCircuitBreakerInstance.execute(task, breakStrategy, breakHandler);
  }

  public static <R, U> R execute(Callable<R> task, BreakStrategy breakStrategy, BreakHandler<R> breakHandler,
                                 U userData) throws CircuitBreakerException {
    return defaultCircuitBreakerInstance.execute(task, breakStrategy, breakHandler, userData);
  }

}
