/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.authorization.service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.savantly.authorization.service.PermissionProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class PermissionAwareUserDetailsService
implements UserDetailsService {
    private UserDetailsService userDetailsService;
    private PermissionProvider permissionProvider;

    public PermissionAwareUserDetailsService(UserDetailsService userDetailsService, PermissionProvider permissionProvider) {
        this.userDetailsService = userDetailsService;
        this.permissionProvider = permissionProvider;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        List<GrantedAuthority> permissions = this.extractPermissions(userDetails);
        return new UserDetailsWrapper(userDetails, permissions);
    }

    private List<GrantedAuthority> extractPermissions(UserDetails userDetails) {
        List<GrantedAuthority> permissions = userDetails.getAuthorities().stream().flatMap(a -> this.permissionProvider.getEffectivePermissions(a.getAuthority()).stream()).distinct().map(p -> new SimpleGrantedAuthority(p)).collect(Collectors.toList());
        permissions.addAll(userDetails.getAuthorities());
        return permissions;
    }

    protected class UserDetailsWrapper
    implements UserDetails {
        private static final long serialVersionUID = 1L;
        UserDetails userDetails;
        private List<GrantedAuthority> permissions;

        public UserDetailsWrapper(UserDetails userDetails, List<GrantedAuthority> permissions) {
            this.userDetails = userDetails;
            this.permissions = permissions;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.permissions;
        }

        public String getPassword() {
            return this.userDetails.getPassword();
        }

        public String getUsername() {
            return this.userDetails.getUsername();
        }

        public boolean isAccountNonExpired() {
            return this.userDetails.isAccountNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.userDetails.isAccountNonLocked();
        }

        public boolean isCredentialsNonExpired() {
            return this.userDetails.isCredentialsNonExpired();
        }

        public boolean isEnabled() {
            return this.userDetails.isEnabled();
        }
    }
}

