/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.metrics.schema;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import net.savantly.metrics.schema.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDefinition
implements Metric {
    private static final Logger log = LoggerFactory.getLogger(MetricDefinition.class);
    private String id;
    private String name;
    private String metric;
    private int interval;
    private String unit;
    private String mtype;
    private String[] tags;
    private long lastUpdate;
    private int partition;
    private double value;

    public MetricDefinition() {
    }

    public MetricDefinition(String str, Style style) {
        switch (style) {
            case Metric_1_0: {
                MetricDefinition.fromMetric_1_0(str, this);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Style not implemented yet: %s", new Object[]{style}));
            }
        }
    }

    public static Metric Factory(String str, Style style) {
        return new MetricDefinition(str, style);
    }

    private static Metric fromMetric_1_0(String str, MetricDefinition metricDefinition) {
        int fieldCount = 3;
        String[] parts = str.split("\\s");
        if (parts.length < fieldCount) {
            if (log.isDebugEnabled()) {
                throw new RuntimeException(String.format("Metric string is missing %s fields: %s", fieldCount - parts.length, str));
            }
            return null;
        }
        metricDefinition.setValue(Double.parseDouble(parts[1]));
        metricDefinition.setLastUpdate(Long.parseLong(parts[2]));
        metricDefinition.setName(parts[0]);
        metricDefinition.setMetric(str);
        try {
            metricDefinition.setId(metricDefinition.createHash());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Failed to create hash for id", (Throwable)e);
        }
        return metricDefinition;
    }

    private String createHash() throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(this.name.getBytes());
        md.update(this.metric.getBytes());
        md.update(String.format("%s", this.lastUpdate).getBytes());
        byte[] digest = md.digest();
        String myHash = DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        return myHash;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getMtype() {
        return this.mtype;
    }

    public void setMtype(String mtype) {
        this.mtype = mtype;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return "MetricDefinition [id=" + this.id + ", name=" + this.name + ", metric=" + this.metric + ", interval=" + this.interval + ", unit=" + this.unit + ", mtype=" + this.mtype + ", tags=" + Arrays.toString(this.tags) + ", lastUpdate=" + this.lastUpdate + ", partition=" + this.partition + ", value=" + this.value + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        Metric_1_0,
        Metric_2_0;

    }
}

