/*
 * Decompiled with CFR 0.152.
 */
package net.sjr.converterutils;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public final class Java8ConverterUtils {

    public static final class SQLDate {
        public static java.sql.Date localDateToSqlDate(LocalDate value) {
            if (value == null) {
                return null;
            }
            return java.sql.Date.valueOf(value);
        }

        public static LocalDate sqlDateToLocalDate(java.sql.Date value) {
            if (value == null) {
                return null;
            }
            return value.toLocalDate();
        }

        public static Timestamp localDateTimeToTimestamp(LocalDateTime value) {
            if (value == null) {
                return null;
            }
            return Timestamp.valueOf(value);
        }

        public static LocalDateTime timestampToLocalDateTime(Timestamp value) {
            if (value == null) {
                return null;
            }
            return value.toLocalDateTime();
        }

        public static Time localTimeToSqlTime(LocalTime value) {
            if (value == null) {
                return null;
            }
            return Time.valueOf(value);
        }

        public static LocalTime sqlTimeToLocalTime(Time value) {
            if (value == null) {
                return null;
            }
            return value.toLocalTime();
        }
    }

    public static final class SQLString {
        private static final DateTimeFormatter ddMMyyyy = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final DateTimeFormatter ddMMyyyyHHmm = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        private static final DateTimeFormatter ddMMyyyyHHmmss = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final DateTimeFormatter HHmm = DateTimeFormatter.ofPattern("HH:mm");

        public static String localDateToString(LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyy);
        }

        public static LocalDate stringToLocalDate(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, ddMMyyyy);
        }

        public static String localDateTimeToString(LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmm);
        }

        public static LocalDateTime stringToLocalDateTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmm);
        }

        public static String localDateTimeToStringWithSeconds(LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmmss);
        }

        public static LocalDateTime stringWithSecondsToLocalDateTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmmss);
        }

        public static String localTimeToString(LocalTime d) {
            if (d == null) {
                return null;
            }
            return d.format(HHmm);
        }

        public static LocalTime stringToLocalTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalTime.parse(s, HHmm);
        }
    }

    public static final class PrettyString {
        private static final DateTimeFormatter MMMyyyy = DateTimeFormatter.ofPattern("MMMM yyyy");
        private static final DateTimeFormatter EEddMMyyyy = DateTimeFormatter.ofPattern("EE dd.MM.yyyy");
        private static final DateTimeFormatter ddMMyyyy = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        private static final DateTimeFormatter ddMMyyyyHHmm = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        private static final DateTimeFormatter ddMMyyyyHHmmss = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        private static final DateTimeFormatter HHmm = DateTimeFormatter.ofPattern("HH:mm");

        public static String localDateToMonthYearString(LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(MMMyyyy);
        }

        public static LocalDate monthYearStringToLocalDate(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, MMMyyyy);
        }

        public static String localDateToWeekdayString(LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(EEddMMyyyy);
        }

        public static LocalDate weekdayStringToLocalDate(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, EEddMMyyyy);
        }

        public static String localDateToString(LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyy);
        }

        public static LocalDate stringToLocalDate(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, ddMMyyyy);
        }

        public static String localDateTimeToString(LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmm);
        }

        public static LocalDateTime stringToLocalDateTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmm);
        }

        public static String localDateTimeToStringWithSeconds(LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmmss);
        }

        public static LocalDateTime stringWithSecondsToLocalDateTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmmss);
        }

        public static String localTimeToString(LocalTime d) {
            if (d == null) {
                return null;
            }
            return d.format(HHmm);
        }

        public static LocalTime stringToLocalTime(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalTime.parse(s, HHmm);
        }
    }

    public static final class UtilJava8Date {
        public static LocalDate utilDateToLocalDate(Date d) {
            if (d == null) {
                return null;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }

        public static Date localDateToUtilDate(LocalDate d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }

        public static LocalDateTime utilDateToLocalDateTime(Date d) {
            if (d == null) {
                return null;
            }
            return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault());
        }

        public static Date localDateTimeToUtilDate(LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atZone(ZoneId.systemDefault()).toInstant());
        }

        public static LocalTime utilDateToLocalTime(Date d) {
            if (d == null) {
                return null;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalTime();
        }

        public static Date localTimeToUtilDate(LocalTime d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }
}

