/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.querying.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runeduniverse.lib.rogm.querying.FilterType;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.ILabeled;
import net.runeduniverse.lib.utils.errors.ExceptionSuppressions;

public abstract class AProxyFilter<FILTER>
implements IFilter,
ILabeled,
InvocationHandler {
    protected FILTER instance;
    protected final Map<Class<?>, Object> handler = new HashMap();
    protected final Map<Method, Object> methodHandlerMapper = new HashMap<Method, Object>();
    protected FilterType filterType = FilterType.MATCH;
    protected Set<String> labels = new HashSet<String>();

    public FILTER addLabel(String label) {
        this.labels.add(label);
        return this.instance;
    }

    public FILTER addLabels(Collection<String> labels) {
        this.labels.addAll(labels);
        return this.instance;
    }

    public Class<?>[] buildInvocationHandler() {
        HashSet l = new HashSet();
        l.add(IFilter.class);
        for (Class<?> clazz : this.instance.getClass().getInterfaces()) {
            l.add(clazz);
        }
        this.handler.forEach((c, i) -> {
            if (i != null) {
                l.add(c);
            }
        });
        this.methodHandlerMapper.clear();
        for (Class clazz : this.handler.keySet()) {
            Object methodHandler = this.handler.get(clazz);
            for (Method m : clazz.getMethods()) {
                this.methodHandlerMapper.put(m, methodHandler);
            }
        }
        for (Method method : this.instance.getClass().getMethods()) {
            this.methodHandlerMapper.put(method, this.instance);
        }
        for (Class<?> clazz : this.instance.getClass().getInterfaces()) {
            for (Method m : clazz.getMethods()) {
                this.methodHandlerMapper.put(m, this.instance);
            }
        }
        return l.toArray(new Class[l.size()]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.methodHandlerMapper.containsKey(method)) {
                return method.invoke(this.methodHandlerMapper.get(method), args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw AProxyFilter.surpressErr(this, proxy, method, args, e);
        }
        throw new Exception("Interface for Method<" + method + "> not found!");
    }

    private static Throwable surpressErr(AProxyFilter<?> instance, Object proxy, Method method, Object[] args, Throwable throwable) {
        String msg = "QueryBuilder > AProxyFilter > invoke()\n  Proxy: " + proxy + "\n  Method: " + method + (args == null ? "" : "\n  args[" + args.length + ']') + ")\n  registered Interfaces:";
        for (Class<?> c : instance.handler.keySet()) {
            msg = msg + "\n  - " + c.getCanonicalName() + " > " + instance.handler.get(c);
        }
        msg = msg + "\n  Mapper:";
        for (Method m : instance.methodHandlerMapper.keySet()) {
            msg = msg + "\n  - " + m + "\n    '-> " + instance.methodHandlerMapper.get(m);
        }
        ExceptionSuppressions surpression = new ExceptionSuppressions(msg);
        surpression.addSuppressed(throwable);
        return surpression;
    }

    public Map<Class<?>, Object> getHandler() {
        return this.handler;
    }

    @Override
    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    @Override
    public Set<String> getLabels() {
        return this.labels;
    }
}

