/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.querying;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.modules.IdTypeResolver;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pattern.INodePattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pattern.IRelationPattern;
import net.runeduniverse.lib.rogm.querying.FilterType;
import net.runeduniverse.lib.rogm.querying.IDataContainer;
import net.runeduniverse.lib.rogm.querying.IFNode;
import net.runeduniverse.lib.rogm.querying.IFRelation;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IIdentified;
import net.runeduniverse.lib.rogm.querying.ILazyLoading;
import net.runeduniverse.lib.rogm.querying.IOptional;
import net.runeduniverse.lib.rogm.querying.IParameterized;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.rogm.querying.IReturned;
import net.runeduniverse.lib.rogm.querying.builder.AProxyFilter;
import net.runeduniverse.lib.rogm.querying.builder.DataContainerHandler;
import net.runeduniverse.lib.rogm.querying.builder.ITraceable;
import net.runeduniverse.lib.rogm.querying.builder.IdentifiedHandler;
import net.runeduniverse.lib.rogm.querying.builder.LazyLoadingHandler;
import net.runeduniverse.lib.rogm.querying.builder.NodeFilter;
import net.runeduniverse.lib.rogm.querying.builder.OptionalHandler;
import net.runeduniverse.lib.rogm.querying.builder.ParamHandler;
import net.runeduniverse.lib.rogm.querying.builder.PatternContainerHandler;
import net.runeduniverse.lib.rogm.querying.builder.RelationFilter;
import net.runeduniverse.lib.rogm.querying.builder.ReturnedHandler;
import net.runeduniverse.lib.utils.common.StringVariableGenerator;
import net.runeduniverse.lib.utils.logging.logs.CompoundTree;

public final class QueryBuilder {
    public static creator<NodeQueryBuilder> CREATOR_NODE_BUILDER = QueryBuilder::createNodeBuilder;
    public static creator<RelationQueryBuilder> CREATOR_REALATION_BUILDER = QueryBuilder::createRelationBuilder;
    private final Archive archive;

    public QueryBuilder(Archive archive) {
        this.archive = archive;
    }

    public NodeQueryBuilder node() {
        return CREATOR_NODE_BUILDER.create(this.archive);
    }

    public RelationQueryBuilder relation() {
        return CREATOR_REALATION_BUILDER.create(this.archive);
    }

    private static NodeQueryBuilder createNodeBuilder(Archive archive) {
        return new NodeQueryBuilder(archive);
    }

    private static RelationQueryBuilder createRelationBuilder(Archive archive) {
        return new RelationQueryBuilder(archive);
    }

    protected static abstract class AQueryBuilder<BUILDER extends AQueryBuilder<?, PROXY_FILTER, PATTERN, RESULT>, PROXY_FILTER extends AProxyFilter<?>, PATTERN extends IBaseQueryPattern<?>, RESULT extends IFilter>
    implements IQueryBuilder<BUILDER, PATTERN, RESULT> {
        protected final Archive archive;
        protected final PROXY_FILTER proxyFilter;
        protected final Map<Class<?>, Object> handler;
        protected boolean autoGenerated = false;
        protected boolean valid = false;
        protected BUILDER instance;
        protected RESULT result = null;
        protected Class<?> type = null;
        protected Serializable id = null;
        protected boolean lazy = false;

        protected AQueryBuilder(Archive archive, PROXY_FILTER proxyFilter) {
            this.archive = archive;
            this.proxyFilter = proxyFilter;
            this.handler = ((AProxyFilter)this.proxyFilter).getHandler();
        }

        @Override
        @Deprecated
        public BUILDER setAutoGenerated(boolean state) {
            this.autoGenerated = state;
            return this.instance;
        }

        @Override
        public BUILDER where(Class<?> type) {
            this.type = type;
            for (IPattern p : this.archive.getPatterns(this.type)) {
                ((AProxyFilter)this.proxyFilter).addLabels(p.getLabels());
                if (!(p instanceof IBaseQueryPattern)) continue;
                this.storePattern((IBaseQueryPattern)p);
            }
            return this.instance;
        }

        @Override
        public BUILDER whereParam(String label, Object value) {
            this.addParam(label, value);
            return this.instance;
        }

        @Override
        public BUILDER whereId(Serializable id) {
            this.id = id;
            return this.instance;
        }

        @Override
        public BUILDER storePattern(PATTERN pattern) {
            if (pattern == null) {
                this.handler.remove(IPattern.IPatternContainer.class);
            } else {
                this.handler.put(IPattern.IPatternContainer.class, new PatternContainerHandler((IBaseQueryPattern<?>)pattern));
            }
            return this.instance;
        }

        @Override
        public BUILDER storeData(Object data) {
            AQueryBuilder.ensure(this.handler, IDataContainer.class, new DataContainerHandler()).setData(data);
            return this.instance;
        }

        @Override
        public BUILDER setLazy(boolean lazy) {
            this.lazy = lazy;
            return this.instance;
        }

        @Override
        public BUILDER setOptional(boolean optional) {
            if (optional) {
                this.handler.put(IOptional.class, new OptionalHandler(optional));
            } else {
                this.handler.remove(IOptional.class);
            }
            return this.instance;
        }

        @Override
        public BUILDER setReturned(boolean returned) {
            if (returned) {
                this.handler.put(IReturned.class, new ReturnedHandler(returned));
            } else {
                this.handler.remove(IReturned.class);
            }
            return this.instance;
        }

        @Override
        public BUILDER setPersist(boolean persist) {
            AQueryBuilder.ensure(this.handler, IDataContainer.class, new DataContainerHandler()).setPersist(persist);
            return this.instance;
        }

        @Override
        public BUILDER setReadonly(boolean readonly) {
            AQueryBuilder.ensure(this.handler, IDataContainer.class, new DataContainerHandler()).setReadonly(readonly);
            return this.instance;
        }

        @Override
        public boolean isAutoGenerated() {
            return this.autoGenerated;
        }

        @Override
        public Set<String> getLabels() {
            return ((AProxyFilter)this.proxyFilter).getLabels();
        }

        @Override
        public PATTERN getStoredPattern() {
            PatternContainerHandler container = (PatternContainerHandler)this.handler.get(IPattern.IPatternContainer.class);
            if (container == null) {
                return null;
            }
            return (PATTERN)container.getPattern();
        }

        @Override
        public Object getStoredData() {
            DataContainerHandler container = (DataContainerHandler)this.handler.get(IDataContainer.class);
            if (container == null) {
                return false;
            }
            return container.getData();
        }

        @Override
        public boolean isOptional() {
            OptionalHandler container = (OptionalHandler)this.handler.get(IOptional.class);
            if (container == null) {
                return false;
            }
            return container.isOptional();
        }

        @Override
        public boolean isReturned() {
            ReturnedHandler container = (ReturnedHandler)this.handler.get(IReturned.class);
            if (container == null) {
                return false;
            }
            return container.isReturned();
        }

        @Override
        public boolean persist() {
            IDataContainer container = (IDataContainer)this.handler.get(IDataContainer.class);
            if (container == null) {
                return false;
            }
            return container.persist();
        }

        @Override
        public boolean isLazy() {
            return this.lazy;
        }

        @Override
        public boolean isReadonly() {
            IDataContainer container = (IDataContainer)this.handler.get(IDataContainer.class);
            if (container == null) {
                return false;
            }
            return container.isReadonly();
        }

        @Override
        public BUILDER asRead() {
            ((AProxyFilter)this.proxyFilter).setFilterType(FilterType.MATCH);
            return this.instance;
        }

        @Override
        public BUILDER asWrite() {
            ((AProxyFilter)this.proxyFilter).setFilterType(FilterType.CREATE);
            return this.instance;
        }

        @Override
        public BUILDER asUpdate() {
            ((AProxyFilter)this.proxyFilter).setFilterType(FilterType.UPDATE);
            return this.instance;
        }

        @Override
        public BUILDER asDelete() {
            ((AProxyFilter)this.proxyFilter).setFilterType(FilterType.DELETE);
            return this.instance;
        }

        public void prebuild() {
            DataContainerHandler dataContainer;
            IdTypeResolver resolver = this.archive.getIdTypeResolver();
            if (this.id != null) {
                if (resolver.checkIdType(this.id.getClass())) {
                    this.handler.put(IIdentified.class, new IdentifiedHandler(this.id));
                } else {
                    this.addParam(resolver.getIdAlias(), this.archive.getIdFieldConverter(this.type).toProperty(this.id));
                }
            }
            if (DataContainerHandler.required(dataContainer = (DataContainerHandler)this.handler.get(IDataContainer.class), ((AProxyFilter)this.proxyFilter).getFilterType())) {
                if (dataContainer == null) {
                    this.handler.put(IDataContainer.class, new DataContainerHandler());
                }
            } else {
                this.handler.remove(IDataContainer.class);
            }
        }

        protected abstract void validateStructure();

        protected abstract RESULT build(Map<IQueryBuilder<?, ?, ?>, IFilter> var1);

        @Override
        public RESULT getResult() {
            if (this.result == null) {
                this.validateStructure();
                this.build(new HashMap());
            }
            return this.result;
        }

        protected abstract void toRecord(CompoundTree var1, StringVariableGenerator var2, Map<IQueryBuilder<?, ?, ?>, String> var3, CompoundTree var4);

        protected void toRecord(CompoundTree tree, StringVariableGenerator gen, Map<IQueryBuilder<?, ?, ?>, String> registry) {
            if (registry.containsKey(this.instance)) {
                return;
            }
            String key = gen.nextVal();
            registry.put((IQueryBuilder<?, ?, ?>)this.instance, key);
            CompoundTree localTree = new CompoundTree((CharSequence)key, (CharSequence)this.instance.getClass().getSimpleName());
            tree.append(localTree);
            localTree.append((CharSequence)"GOAL", (CharSequence)((AProxyFilter)this.proxyFilter).getFilterType().name()).append((CharSequence)"ORIGIN", (CharSequence)(this.autoGenerated ? "AUTO" : "MANUAL")).append((CharSequence)"VALIDATED", (CharSequence)(this.valid ? "YES" : "NOT YET"));
            if (this.type != null) {
                localTree.append((CharSequence)"TYPE", (CharSequence)this.type.getCanonicalName());
            }
            if (this.id != null) {
                localTree.append((CharSequence)"ID", (CharSequence)this.id.toString());
            }
            localTree.append((CharSequence)"STATUS", (CharSequence)(this.lazy ? "LAZY" : "COMPLETE"));
            if (!((AProxyFilter)this.proxyFilter).getLabels().isEmpty()) {
                localTree.append((CharSequence)"LABELS", (CharSequence)String.join((CharSequence)", ", ((AProxyFilter)this.proxyFilter).getLabels()));
            }
            this.toRecord(tree, gen, registry, localTree);
            for (Object handler : this.handler.values()) {
                ITraceable.toRecord(localTree, handler);
            }
        }

        public String toString() {
            CompoundTree tree = new CompoundTree((CharSequence)"\nQueryBuilder Trace:");
            this.toRecord(tree, new StringVariableGenerator(), new HashMap());
            return tree.toString();
        }

        protected void addParam(String label, Object value) {
            AQueryBuilder.ensure(this.handler, IParameterized.class, new ParamHandler()).addParam(label, value);
        }

        protected static <T> T ensure(Map<Class<?>, Object> handler, Class<?> keyInterface, T instance) {
            if (!handler.containsKey(keyInterface)) {
                handler.put(keyInterface, instance);
            }
            return (T)handler.get(keyInterface);
        }
    }

    public static class RelationQueryBuilder
    extends AQueryBuilder<RelationQueryBuilder, RelationFilter, IRelationPattern<RelationQueryBuilder>, IFRelation> {
        protected Direction direction = Direction.BIDIRECTIONAL;
        protected NodeQueryBuilder startNodeBuilder = null;
        protected NodeQueryBuilder targetNodeBuilder = null;

        public RelationQueryBuilder(Archive archive) {
            super(archive, new RelationFilter());
            this.instance = this;
        }

        public RelationQueryBuilder whereDirection(Direction direction) {
            this.direction = direction == null ? Direction.BIDIRECTIONAL : direction;
            return this;
        }

        public RelationQueryBuilder setStart(NodeQueryBuilder start) {
            this.startNodeBuilder = start.addRelation(this);
            return this;
        }

        public RelationQueryBuilder setTarget(NodeQueryBuilder target) {
            this.targetNodeBuilder = target.addRelation(this);
            return this;
        }

        public NodeQueryBuilder getStart() {
            return this.startNodeBuilder;
        }

        public NodeQueryBuilder getTarget() {
            return this.targetNodeBuilder;
        }

        @Override
        protected IFRelation build(Map<IQueryBuilder<?, ?, ?>, IFilter> registry) {
            if (registry.containsKey(this)) {
                return (IFRelation)registry.get(this);
            }
            super.prebuild();
            ((RelationFilter)this.proxyFilter).setDirection(this.direction);
            this.result = (IFRelation)Proxy.newProxyInstance(QueryBuilder.class.getClassLoader(), ((RelationFilter)this.proxyFilter).buildInvocationHandler(), (InvocationHandler)this.proxyFilter);
            registry.put(this, (IFilter)this.result);
            ((RelationFilter)this.proxyFilter).setStart((IFNode)(this.startNodeBuilder == null ? null : this.startNodeBuilder.build((Map)registry)));
            ((RelationFilter)this.proxyFilter).setTarget((IFNode)(this.targetNodeBuilder == null ? null : this.targetNodeBuilder.build((Map)registry)));
            return (IFRelation)this.result;
        }

        @Override
        protected void validateStructure() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            FilterType thisFilterType = ((RelationFilter)this.proxyFilter).getFilterType();
            boolean isNotCreate = true;
            if (this.startNodeBuilder != null) {
                this.startNodeBuilder.validateStructure();
                if (((NodeFilter)this.startNodeBuilder.proxyFilter).getFilterType() == FilterType.CREATE) {
                    if (thisFilterType != FilterType.CREATE) {
                        this.asUpdate();
                    }
                    isNotCreate = false;
                }
            }
            if (this.targetNodeBuilder != null) {
                this.targetNodeBuilder.validateStructure();
                if (((NodeFilter)this.targetNodeBuilder.proxyFilter).getFilterType() == FilterType.CREATE) {
                    if (thisFilterType != FilterType.CREATE) {
                        this.asUpdate();
                    }
                    isNotCreate = false;
                }
            }
            if (isNotCreate && this.type != null && this.isReturned() && !this.isAutoGenerated()) {
                try {
                    ((IRelationPattern)this.getStoredPattern()).completeSearch(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void toRecord(CompoundTree tree, StringVariableGenerator gen, Map<IQueryBuilder<?, ?, ?>, String> registry, CompoundTree localTree) {
            this.startNodeBuilder.toRecord(tree, gen, registry);
            this.targetNodeBuilder.toRecord(tree, gen, registry);
            localTree.append((CharSequence)"DIRECTION", (CharSequence)this.direction.name());
            localTree.append((CharSequence)"START", (CharSequence)("(" + registry.get(this.startNodeBuilder) + ")"));
            localTree.append((CharSequence)"TARGET", (CharSequence)("(" + registry.get(this.targetNodeBuilder) + ")"));
        }

        public CharSequence toRecord2(CompoundTree tree, StringVariableGenerator gen, Map<IQueryBuilder<?, ?, ?>, String> registry) {
            super.toRecord(tree, gen, registry);
            return String.format("(%s) %s-[%s]-%s (%s)", this.startNodeBuilder == null ? "" : registry.get(this.startNodeBuilder), this.direction == Direction.OUTGOING ? "-" : "<", registry.get(this), this.direction == Direction.INCOMING ? "-" : ">", this.targetNodeBuilder == null ? "" : registry.get(this.targetNodeBuilder));
        }
    }

    public static class NodeQueryBuilder
    extends AQueryBuilder<NodeQueryBuilder, NodeFilter, INodePattern<NodeQueryBuilder>, IFNode> {
        protected Set<RelationQueryBuilder> relationBuilders = new HashSet<RelationQueryBuilder>();

        public NodeQueryBuilder(Archive archive) {
            super(archive, new NodeFilter());
            this.instance = this;
        }

        @Deprecated
        public NodeQueryBuilder addRelation(RelationQueryBuilder relation) {
            this.relationBuilders.add(relation);
            return this;
        }

        public NodeQueryBuilder addRelationTo(NodeQueryBuilder target) {
            this.archive.getQueryBuilder().relation().setStart(this).setTarget(target);
            return this;
        }

        public NodeQueryBuilder addRelationTo(RelationQueryBuilder relation, NodeQueryBuilder target) {
            relation.setStart(this).setTarget(target);
            return this;
        }

        public NodeQueryBuilder addRelationFrom(NodeQueryBuilder start) {
            this.archive.getQueryBuilder().relation().setStart(start).setTarget(this);
            return this;
        }

        public NodeQueryBuilder addRelationFrom(RelationQueryBuilder relation, NodeQueryBuilder start) {
            relation.setStart(start).setTarget(this);
            return this;
        }

        @Override
        public NodeQueryBuilder setLazy(boolean lazy) {
            if (lazy) {
                this.handler.put(ILazyLoading.class, new LazyLoadingHandler(lazy));
            } else {
                this.handler.remove(ILazyLoading.class);
            }
            return (NodeQueryBuilder)super.setLazy(lazy);
        }

        @Override
        protected void validateStructure() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            for (RelationQueryBuilder builder : this.relationBuilders) {
                builder.validateStructure();
            }
            FilterType thisFilterType = ((NodeFilter)this.proxyFilter).getFilterType();
            if ((thisFilterType == FilterType.MATCH || thisFilterType == FilterType.DELETE) && this.type != null && this.isReturned() && !this.isAutoGenerated()) {
                try {
                    ((INodePattern)this.getStoredPattern()).completeSearch(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected IFNode build(Map<IQueryBuilder<?, ?, ?>, IFilter> registry) {
            if (registry.containsKey(this)) {
                return (IFNode)registry.get(this);
            }
            super.prebuild();
            this.result = (IFNode)Proxy.newProxyInstance(QueryBuilder.class.getClassLoader(), ((NodeFilter)this.proxyFilter).buildInvocationHandler(), (InvocationHandler)this.proxyFilter);
            registry.put(this, (IFilter)this.result);
            for (RelationQueryBuilder rqb : this.relationBuilders) {
                ((NodeFilter)this.proxyFilter).getRelations().add((IFRelation)rqb.build((Map)registry));
            }
            return (IFNode)this.result;
        }

        @Override
        protected void toRecord(CompoundTree tree, StringVariableGenerator gen, Map<IQueryBuilder<?, ?, ?>, String> registry, CompoundTree localTree) {
            for (RelationQueryBuilder rqb : this.relationBuilders) {
                localTree.append((CharSequence)"REL", rqb.toRecord2(tree, gen, registry));
            }
        }
    }

    @FunctionalInterface
    public static interface creator<BUILDER> {
        public BUILDER create(Archive var1);
    }
}

