/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.querying;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.querying.AParamFilter;
import net.runeduniverse.lib.rogm.querying.FilterRelation;
import net.runeduniverse.lib.rogm.querying.IFNode;
import net.runeduniverse.lib.rogm.querying.IFRelation;
import net.runeduniverse.lib.rogm.querying.IIdentified;

public class FilterNode
extends AParamFilter<FilterNode>
implements IFNode,
IIdentified<Serializable> {
    Set<IFRelation> relations = new HashSet<IFRelation>();
    private Serializable id;

    public FilterNode() {
        super.setInstance(this);
    }

    public FilterNode(Serializable id) {
        this.id = id;
        super.setInstance(this);
    }

    public FilterNode addRelation(IFRelation relation) {
        this.relations.add(relation);
        return this;
    }

    public FilterNode addRelation(FilterRelation relation, IFNode target) {
        this.relations.add(relation.setStart(this).setTarget(target));
        return this;
    }

    public FilterNode addRelationTo(IFNode node) {
        this.relations.add(new FilterRelation(this, node, Direction.OUTGOING));
        return this;
    }

    public FilterNode addRelationTo(FilterRelation relation) {
        this.relations.add(relation.setStart(this).setDirection(Direction.OUTGOING));
        return this;
    }

    public FilterNode addRelationFrom(IFNode node) {
        this.relations.add(new FilterRelation(node, this, Direction.INCOMING));
        return this;
    }

    public FilterNode addRelationFrom(FilterRelation relation) {
        this.relations.add(relation.setTarget(this).setDirection(Direction.INCOMING));
        return this;
    }

    @Override
    public Set<IFRelation> getRelations() {
        return this.relations;
    }

    @Override
    public Serializable getId() {
        return this.id;
    }
}

