/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline.chain.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runeduniverse.lib.rogm.annotations.PostSave;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.querying.IDataContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.utils.errors.ExceptionSuppressions;

public class SaveContainer {
    protected final Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData = new HashMap();
    protected IDataContainer container;
    protected EffectedFilterCalculator calculator = (a, b, i) -> new HashSet();

    public SaveContainer(DataContainerCreator creator2) throws Exception {
        this(creator2, null);
    }

    public SaveContainer(DataContainerCreator creator2, EffectedFilterCalculator calculator) throws Exception {
        this.container = creator2.create(this.includedData);
        this.setCalculator(calculator);
    }

    public IDataContainer getDataContainer() {
        return this.container;
    }

    public Set<IFilter> calculateEffectedFilter(Archive archive, IBuffer buffer) throws Exception {
        return this.calculator.calculate(archive, buffer, this.includedData);
    }

    public void postSave(Archive archive) throws ExceptionSuppressions {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Object object : this.includedData.keySet()) {
            if (object == null) continue;
            try {
                archive.callMethod(object.getClass(), PostSave.class, object, new Object[0]);
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new ExceptionSuppressions("Surpressed Exceptions for @PostSave Event", true).addSuppressed(errors);
        }
    }

    public void setDataContainer(IDataContainer container) {
        this.container = container;
    }

    public void setCalculator(EffectedFilterCalculator calculator) {
        if (calculator == null) {
            return;
        }
        this.calculator = calculator;
    }

    public String toString() {
        return "SaveContainer(includedData=" + this.getIncludedData() + ", container=" + this.container + ", calculator=" + this.calculator + ")";
    }

    public Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> getIncludedData() {
        return this.includedData;
    }

    @FunctionalInterface
    public static interface EffectedFilterCalculator {
        public Set<IFilter> calculate(Archive var1, IBuffer var2, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> var3) throws Exception;
    }

    @FunctionalInterface
    public static interface DataContainerCreator {
        public IDataContainer create(Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> var1) throws Exception;
    }
}

