/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline.chain;

import java.util.Collection;
import java.util.Iterator;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pipeline.chain.data.DepthContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityCollectionContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.LazyEntriesContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.RelatedEntriesContainer;
import net.runeduniverse.lib.utils.chain.Chain;
import net.runeduniverse.lib.utils.chain.ChainRuntime;
import net.runeduniverse.lib.utils.chain.Chains;

public interface ReduceLayer {
    @Chain(label="LOAD_CHAIN.ONE", layers={450}, ignoreResult=true)
    public static <T> T reduceCollection(ChainRuntime<T> runtime, Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            runtime.setResult(t);
            return t;
        }
        return null;
    }

    @Chains(value={@Chain(label="LOAD_CHAIN.ALL", layers={500}, ignoreResult=true), @Chain(label="LOAD_CHAIN.ONE", layers={500}, ignoreResult=true)})
    public static void resolveDepth(ChainRuntime<?> runtime, DepthContainer depth) throws Exception {
        if (depth.getValue() < 2) {
            return;
        }
        depth.subtractOne();
        runtime.callSubChainWithSourceData("LOAD_CHAIN.RESOLVE_LAZY.ALL", null, new Object[0]);
    }

    @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.ALL", layers={100})
    public static void validateLazyEntries(ChainRuntime<?> runtime, LazyEntriesContainer lazyEntries, DepthContainer depth) {
        if (lazyEntries.isEmpty() || depth == null || depth.getValue() <= 0) {
            runtime.setCanceled(true);
        }
    }

    @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.ALL", layers={200})
    public static void resolveLazyEntries(ChainRuntime<?> runtime, Archive archive, LazyEntriesContainer lazyEntries) throws Exception {
        LazyEntriesContainer nextLazyEntries = new LazyEntriesContainer();
        for (BufferTypes.IEntry entry : lazyEntries.getLazyEntries()) {
            runtime.callSubChainWithSourceData("LOAD_CHAIN.RESOLVE_LAZY.SELECTED", Collection.class, new Object[]{archive.search(entry.getType(), entry.getId(), false).getResult(), nextLazyEntries});
        }
        lazyEntries.clear();
        lazyEntries.addEntries(nextLazyEntries);
    }

    @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.ALL", layers={300})
    public static void loopLazyEntries(ChainRuntime<?> runtime, DepthContainer depth) {
        depth.subtractOne();
        if (0 < depth.getValue()) {
            runtime.jumpToLayer(100);
        }
    }

    @Chain(label="RELOAD_CHAIN.ALL", layers={100})
    public static void reloadEntries(ChainRuntime<?> runtime, Archive archive, IBuffer buffer, EntityCollectionContainer entityCollection, DepthContainer depth) throws Exception {
        RelatedEntriesContainer relatedEntries = (RelatedEntriesContainer)runtime.storeData((Object)new RelatedEntriesContainer());
        for (Object entity : entityCollection.getEntityCollection()) {
            BufferTypes.IEntry entry = buffer.getEntry(entity);
            if (entry == null) continue;
            runtime.callSubChainWithSourceData("RELOAD_CHAIN.SELECTED", Void.class, new Object[]{relatedEntries, archive.search(entry.getType(), entry.getId(), depth.getValue() == 0).getResult()});
        }
        depth.subtractOne();
    }

    @Chain(label="RELOAD_CHAIN.ALL", layers={200})
    public static void validateRelatedEntries(ChainRuntime<?> runtime, DepthContainer depth, RelatedEntriesContainer relatedEntries) {
        if (relatedEntries.isEmpty() || depth == null || depth.getValue() <= 0) {
            runtime.setCanceled(true);
        }
    }

    @Chain(label="RELOAD_CHAIN.ALL", layers={300})
    public static void reloadRelatedEntries(ChainRuntime<?> runtime, Archive archive, IBuffer buffer, RelatedEntriesContainer relatedEntries, DepthContainer depth) throws Exception {
        RelatedEntriesContainer nextRelatedEntries = new RelatedEntriesContainer();
        for (BufferTypes.IEntry entry : relatedEntries.getRelatedEntries()) {
            if (entry == null) continue;
            runtime.callSubChainWithSourceData("RELOAD_CHAIN.SELECTED", Void.class, new Object[]{nextRelatedEntries, archive.search(entry.getType(), entry.getId(), depth.getValue() == 0).getResult()});
        }
        relatedEntries.clear();
        relatedEntries.addEntries(nextRelatedEntries);
    }

    @Chain(label="RELOAD_CHAIN.ALL", layers={400})
    public static void loopRelatedEntries(ChainRuntime<?> runtime, DepthContainer depth) {
        depth.subtractOne();
        if (0 < depth.getValue()) {
            runtime.jumpToLayer(200);
        }
    }
}

