/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline.chain;

import java.util.Collection;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.lang.DatabaseCleaner;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.DepthContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.UpdatedEntryContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.utils.chain.Chain;
import net.runeduniverse.lib.utils.chain.ChainRuntime;
import net.runeduniverse.lib.utils.chain.Chains;
import net.runeduniverse.lib.utils.common.StringUtils;
import net.runeduniverse.lib.utils.errors.ExceptionSuppressions;

public interface LookupLayers {
    @Chain(label="DELETE_CHAIN.ONE", layers={200})
    public static IPattern.IDeleteContainer packageContainer(Archive archive, EntityContainer entity, BufferTypes.IEntry entry) throws Exception {
        return archive.delete(entity.getType(), entry.getId(), entity.getEntity());
    }

    @Chains(value={@Chain(label="LOAD_CHAIN.ALL", layers={100}), @Chain(label="LOAD_CHAIN.ONE", layers={100}), @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.SELECTED", layers={100}), @Chain(label="RELOAD_CHAIN.SELECTED", layers={100})})
    public static Language.ILoadMapper buildQryMapper(Language.Instance lang, IFilter filter) throws Exception {
        return lang.load(filter);
    }

    @Chain(label="SAVE_CHAIN.ONE", layers={100})
    public static Language.ISaveMapper buildSaveMapper(Archive archive, IBuffer buffer, Language.Instance lang, SaveContainer container) throws Exception {
        return lang.save(container.getDataContainer(), container.calculateEffectedFilter(archive, buffer));
    }

    @Chain(label="DELETE_CHAIN.ONE", layers={300})
    public static Language.IDeleteMapper buildDeleteMapper(Language.Instance lang, IPattern.IDeleteContainer container) throws Exception {
        return lang.delete(container.getDeleteFilter(), container.getEffectedFilter());
    }

    @Chains(value={@Chain(label="LOAD_CHAIN.ALL", layers={200}), @Chain(label="LOAD_CHAIN.ONE", layers={200}), @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.SELECTED", layers={200}), @Chain(label="RELOAD_CHAIN.SELECTED", layers={200})})
    public static Module.IRawDataRecord queryDatabase(Module.Instance<?> db, Language.IMapper mapper) {
        return db.queryObject(mapper.qry());
    }

    @Chains(value={@Chain(label="SAVE_CHAIN.ONE", layers={200}), @Chain(label="DELETE_CHAIN.ONE", layers={600})})
    public static Module.IRawIdRecord executeQry(Module.Instance<?> db, Language.IMapper mapper) {
        return db.execute(mapper.qry());
    }

    @Chain(label="DELETE_CHAIN.ONE", layers={400})
    public static Module.IRawRecord queryDatabase(Module.Instance<?> module, Language.IDeleteMapper mapper) {
        return module.query(mapper.effectedQry());
    }

    @Chains(value={@Chain(label="LOAD_CHAIN.ALL", layers={300}), @Chain(label="LOAD_CHAIN.ONE", layers={300}), @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.SELECTED", layers={300}), @Chain(label="RELOAD_CHAIN.SELECTED", layers={300})})
    public static IPattern.IDataRecord convertRecord(Language.ILoadMapper mapper, Module.IRawDataRecord rawDataRecord) {
        return mapper.parseDataRecord(rawDataRecord.getData());
    }

    @Chain(label="SAVE_CHAIN.ONE", layers={300})
    public static Collection<UpdatedEntryContainer> collectUpdatedEntries(Language.ISaveMapper mapper, Module.IRawIdRecord record, DepthContainer depth) {
        return mapper.updateObjectIds(record.getIds(), BufferTypes.LoadState.get(depth.getValue() == 0));
    }

    @Chain(label="SAVE_CHAIN.ONE", layers={500})
    public static void callDatabaseCleanup(ChainRuntime<?> runtime, DatabaseCleaner cleaner) throws Exception {
        if (!StringUtils.isBlank((String)cleaner.getChainLabel())) {
            runtime.callSubChainWithRuntimeData(cleaner.getChainLabel(), Void.class, new Object[0]);
        }
    }

    @Chain(label="SAVE_CHAIN.ONE", layers={550})
    public static void triggerPostSaveEvent(Archive archive, SaveContainer container) throws ExceptionSuppressions {
        container.postSave(archive);
    }
}

