/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline.chain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.annotations.PostLoad;
import net.runeduniverse.lib.rogm.annotations.PostReload;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pattern.NodePattern;
import net.runeduniverse.lib.rogm.pattern.RelationPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.RelatedEntriesContainer;
import net.runeduniverse.lib.rogm.querying.IFNode;
import net.runeduniverse.lib.rogm.querying.IFRelation;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.utils.chain.Chain;
import net.runeduniverse.lib.utils.chain.ChainRuntime;
import net.runeduniverse.lib.utils.chain.Chains;
import net.runeduniverse.lib.utils.common.DataHashMap;
import net.runeduniverse.lib.utils.common.DataMap;

public interface AssemblyLayers
extends BufferTypes {
    @Chains(value={@Chain(label="LOAD_CHAIN.ALL", layers={400}), @Chain(label="LOAD_CHAIN.ONE", layers={400}), @Chain(label="LOAD_CHAIN.RESOLVE_LAZY.SELECTED", layers={400})})
    public static <T> Collection<T> load(ChainRuntime<?> runtime, Archive archive, IBuffer buffer, IPattern.IDataRecord record) throws Exception {
        Class<?> returnType;
        IFilter primaryFilter = record.getPrimaryFilter();
        if ((runtime.getResultType() == Object.class || runtime.getResultType() == Collection.class) && primaryFilter != null && primaryFilter instanceof IPattern.IPatternContainer) {
            IBaseQueryPattern<?> primaryPattern = ((IPattern.IPatternContainer)primaryFilter).getPattern();
            returnType = primaryPattern.getType();
        } else {
            returnType = runtime.getResultType();
        }
        ArrayList<DataHashMap> dataRecords = new ArrayList<DataHashMap>();
        HashSet<Object> loadedObjects = new HashSet<Object>();
        for (Set<IPattern.IData> set : record.getData()) {
            DataHashMap map = new DataHashMap();
            dataRecords.add(map);
            for (IPattern.IData data2 : set) {
                IFilter dataFilter = data2.getFilter();
                map.put((Object)dataFilter, (Object)data2, (Object)DataType.fromFilter(dataFilter));
                if (!IPattern.IPatternContainer.identify(dataFilter)) continue;
                IBaseQueryPattern<?> dataPattern = ((IPattern.IPatternContainer)dataFilter).getPattern();
                loadedObjects.add(runtime.callSubChainWithRuntimeData("BUFFER_CHAIN.LOAD", dataPattern.getType(), new Object[]{data2, dataPattern}));
            }
        }
        for (DataMap dataMap : dataRecords) {
            dataMap.forEach((Object)DataType.RELATION, (filter, data) -> {
                IFRelation fRelation = (IFRelation)filter;
                String label = fRelation.getPrimaryLabel();
                IFNode fStartNode = fRelation.getStart();
                NodePattern pStartNode = (NodePattern)((IPattern.IPatternContainer)((Object)fStartNode)).getPattern();
                Object eStartNode = buffer.getById(((IPattern.IData)dataMap.get((Object)fStartNode)).getId(), pStartNode.getType());
                IFNode fTargetNode = fRelation.getTarget();
                NodePattern pTargetNode = (NodePattern)((IPattern.IPatternContainer)((Object)fTargetNode)).getPattern();
                Object eTargetNode = buffer.getById(((IPattern.IData)dataMap.get((Object)fTargetNode)).getId(), pTargetNode.getType());
                if (!IPattern.IPatternContainer.identify(fRelation)) {
                    pStartNode.setRelation(fRelation.getDirection(), label, eStartNode, eTargetNode);
                    pTargetNode.setRelation(Direction.opposing(fRelation.getDirection()), label, eTargetNode, eStartNode);
                    return;
                }
                RelationPattern rel = (RelationPattern)((IPattern.IPatternContainer)((Object)fRelation)).getPattern();
                Object relEntity = buffer.getById(data.getId(), rel.getType());
                rel.setStart(relEntity, eStartNode);
                rel.setTarget(relEntity, eTargetNode);
                pStartNode.setRelation(fRelation.getDirection(), label, eStartNode, relEntity);
                pTargetNode.setRelation(Direction.opposing(fRelation.getDirection()), label, eTargetNode, relEntity);
            });
        }
        HashSet nodes = new HashSet();
        if (returnType != null) {
            for (Serializable primId : record.getIds()) {
                Object o = buffer.getById(primId, returnType);
                if (o == null) continue;
                nodes.add(o);
            }
            runtime.setPossibleResult(nodes);
        }
        for (Object object : loadedObjects) {
            archive.callMethod(object.getClass(), PostLoad.class, object, new Object[0]);
        }
        return nodes;
    }

    @Chain(label="RELOAD_CHAIN.SELECTED", layers={400})
    public static void update(ChainRuntime<?> runtime, Archive archive, IBuffer buffer, EntityContainer entityContainer, RelatedEntriesContainer relatedEntities, IPattern.IDataRecord record) throws Exception {
        Object entity = entityContainer.getEntity();
        ArrayList<DataHashMap> dataRecords = new ArrayList<DataHashMap>();
        for (Set<IPattern.IData> set : record.getData()) {
            DataHashMap map = new DataHashMap();
            dataRecords.add(map);
            for (IPattern.IData data2 : set) {
                IBaseQueryPattern<?> dataPattern;
                BufferTypes.IEntry entry;
                IFilter dataFilter = data2.getFilter();
                DataType dtype = DataType.fromFilter(dataFilter);
                map.put((Object)data2.getFilter(), (Object)data2, (Object)dtype);
                if (!IPattern.IPatternContainer.identify(dataFilter) || BufferTypes.LoadState.get(dataFilter) != BufferTypes.LoadState.LAZY || (entry = (BufferTypes.IEntry)runtime.callSubChainWithSourceData("BUFFER_CHAIN.UPDATE", BufferTypes.IEntry.class, new Object[]{data2, dataPattern = ((IPattern.IPatternContainer)dataFilter).getPattern()})).getEntity() == entity || dtype == DataType.RELATION) continue;
                relatedEntities.addEntry(entry);
            }
        }
        for (DataMap dataMap : dataRecords) {
            dataMap.forEach((Object)DataType.RELATION, (filter, data) -> {
                IFRelation fRelation = (IFRelation)filter;
                String label = fRelation.getPrimaryLabel();
                IFNode fStartNode = fRelation.getStart();
                NodePattern pStartNode = (NodePattern)((IPattern.IPatternContainer)((Object)fStartNode)).getPattern();
                Object eStartNode = buffer.getById(((IPattern.IData)dataMap.get((Object)fStartNode)).getId(), pStartNode.getType());
                IFNode fTargetNode = fRelation.getTarget();
                NodePattern pTargetNode = (NodePattern)((IPattern.IPatternContainer)((Object)fTargetNode)).getPattern();
                Object eTargetNode = buffer.getById(((IPattern.IData)dataMap.get((Object)fTargetNode)).getId(), pTargetNode.getType());
                pStartNode.deleteRelations(eStartNode);
                pTargetNode.deleteRelations(eTargetNode);
                if (!IPattern.IPatternContainer.identify(fRelation)) {
                    pStartNode.setRelation(fRelation.getDirection(), label, eStartNode, eTargetNode);
                    pTargetNode.setRelation(Direction.opposing(fRelation.getDirection()), label, eTargetNode, eStartNode);
                    return;
                }
                RelationPattern rel = (RelationPattern)((IPattern.IPatternContainer)((Object)fRelation)).getPattern();
                Object relEntity = buffer.getById(data.getId(), rel.getType());
                rel.setStart(relEntity, null);
                rel.setTarget(relEntity, null);
                rel.setStart(relEntity, eStartNode);
                rel.setTarget(relEntity, eTargetNode);
                pStartNode.setRelation(fRelation.getDirection(), label, eStartNode, relEntity);
                pTargetNode.setRelation(Direction.opposing(fRelation.getDirection()), label, eTargetNode, relEntity);
            });
        }
        archive.callMethod(entity.getClass(), PostReload.class, entity, new Object[0]);
    }

    public static enum DataType {
        NODE,
        RELATION,
        UNKNOWN;


        static DataType fromFilter(IFilter filter) {
            if (filter instanceof IFNode) {
                return NODE;
            }
            if (filter instanceof IFRelation) {
                return RELATION;
            }
            return UNKNOWN;
        }
    }
}

