/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import net.runeduniverse.lib.rogm.Session;
import net.runeduniverse.lib.rogm.info.SessionInfo;
import net.runeduniverse.lib.rogm.logging.PipelineLogger;
import net.runeduniverse.lib.rogm.logging.SessionLogger;
import net.runeduniverse.lib.rogm.pipeline.AChainRouter;
import net.runeduniverse.lib.rogm.pipeline.APipelineFactory;
import net.runeduniverse.lib.rogm.pipeline.Pipeline;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;

public final class SessionWrapper
implements Session {
    private final Pipeline pipeline;
    private final APipelineFactory<?> factory;
    private final AChainRouter router;
    private final SessionLogger logger;

    protected SessionWrapper(Pipeline pipeline, APipelineFactory<?> factory, PipelineLogger pipelineLogger, SessionInfo info) {
        this.pipeline = pipeline;
        this.factory = factory;
        this.router = this.factory.getRouter();
        this.logger = new SessionLogger(SessionWrapper.class, pipelineLogger).logSessionInfo(info);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws Exception {
        this.pipeline.closeConnections(this);
    }

    @Override
    public boolean isConnected() {
        return this.factory.isConnected();
    }

    private <T, ID extends Serializable> T _load(Class<T> type, ID id, Integer depth) {
        try {
            return this.router.load(type, id, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Loading of Class<" + type.getCanonicalName() + "> Entity with id=" + id + " (depth=" + depth + ") failed!", e);
            return null;
        }
    }

    private <T, ID extends Serializable> Collection<T> _loadAll(Class<T> type, ID id, Integer depth) {
        try {
            return this.router.loadAll(type, id, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Loading of Class<" + type.getCanonicalName() + "> Entities with id=" + id + " (depth=" + depth + ") failed!", e);
            return new ArrayList();
        }
    }

    private <T, ID extends Serializable> Collection<T> _loadAll(Class<T> type, Integer depth) {
        try {
            return this.router.loadAll(type, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Loading of Class<" + type.getCanonicalName() + "> Entities (depth=" + depth + ") failed!", e);
            return new ArrayList();
        }
    }

    private void _save(Object entity, Integer depth) {
        try {
            this.router.save(entity, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Saving of Class<" + entity.getClass().getCanonicalName() + "> Entity failed! (depth=" + depth + ')', e);
        }
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id) {
        return this._load(type, id, 1);
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id, Integer depth) {
        if (depth < 0) {
            depth = 0;
        }
        return this._load(type, id, depth);
    }

    @Override
    public <T, ID extends Serializable> T loadLazy(Class<T> type, ID id) {
        return this._load(type, id, 0);
    }

    @Override
    public <T> T load(IFilter filter) {
        try {
            return (T)this.router.load(filter);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Loading of Class Entity by custom Filter failed!", e);
            return null;
        }
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, ID id) {
        return this._loadAll(type, id, 1);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, ID id, Integer depth) {
        if (depth < 0) {
            depth = 0;
        }
        return this._loadAll(type, id, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAllLazy(Class<T> type, ID id) {
        return this._loadAll(type, id, 0);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this._loadAll(type, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Integer depth) {
        if (depth < 0) {
            depth = 0;
        }
        return this._loadAll(type, depth);
    }

    @Override
    public <T> Collection<T> loadAllLazy(Class<T> type) {
        return this._loadAll(type, 0);
    }

    @Override
    public <T> Collection<T> loadAll(IFilter filter) {
        try {
            return this.router.loadAll(filter);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Loading of Class Entities by custom Filter failed!", e);
            return Collections.emptyList();
        }
    }

    @Override
    public void resolveLazyLoaded(Object entity) {
        this.resolveAllLazyLoaded(Arrays.asList(entity), 1);
    }

    @Override
    public void resolveLazyLoaded(Object entity, Integer depth) {
        this.resolveAllLazyLoaded(Arrays.asList(entity), depth);
    }

    @Override
    public void resolveAllLazyLoaded(Collection<? extends Object> entities) {
        this.resolveAllLazyLoaded(entities, 1);
    }

    @Override
    public void resolveAllLazyLoaded(Collection<? extends Object> entities, Integer depth) {
        try {
            this.router.resolveAllLazyLoaded(entities, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Resolving of lazy loaded Buffer-Entries failed!", e);
        }
    }

    @Override
    public void reload(Object entity) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(entity);
        try {
            this.router.reloadAll(set, 1);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Reloading of Class-Entity of Class<" + entity.getClass().getCanonicalName() + "> failed!", e);
        }
    }

    @Override
    public void reload(Object entity, Integer depth) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(entity);
        try {
            this.router.reloadAll(set, depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Reloading of Class-Entity of Class<" + entity.getClass().getCanonicalName() + "> failed!", e);
        }
    }

    @Override
    public void reloadAll(Collection<? extends Object> entities) {
        try {
            this.router.reloadAll(new HashSet<Object>(entities), 1);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Reloading of Class-Entities failed!", e);
        }
    }

    @Override
    public void reloadAll(Collection<? extends Object> entities, Integer depth) {
        try {
            this.router.reloadAll(new HashSet<Object>(entities), depth);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Reloading of Class-Entities failed!", e);
        }
    }

    @Override
    public void save(Object entity) {
        this._save(entity, 1);
    }

    @Override
    public void save(Object entity, Integer depth) {
        if (depth < 0) {
            depth = 0;
        }
        this._save(entity, depth);
    }

    @Override
    public void saveLazy(Object entity) {
        this._save(entity, 0);
    }

    @Override
    public void saveAll(Collection<? extends Object> entities) {
        for (Object object : entities) {
            this._save(object, 1);
        }
    }

    @Override
    public void saveAll(Collection<? extends Object> entities, Integer depth) {
        if (depth < 0) {
            depth = 0;
        }
        for (Object object : entities) {
            this._save(object, depth);
        }
    }

    @Override
    public void saveAllLazy(Collection<? extends Object> entities) {
        for (Object object : entities) {
            this._save(object, 0);
        }
    }

    @Override
    public void delete(Object entity) {
        try {
            this.router.delete(entity, 1);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Deletion of Class-Entity of Type<" + entity.getClass().getCanonicalName() + "> failed!", e);
        }
    }

    @Override
    public void deleteAll(Collection<? extends Object> entities) {
        for (Object object : entities) {
            this.delete(object);
        }
    }

    @Override
    public void unload(Object entity) {
        this.router.unload(entity);
    }

    @Override
    public void unloadAll(Collection<? extends Object> entities) {
        for (Object object : entities) {
            this.unload(object);
        }
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return this.factory.getQueryBuilder();
    }
}

