/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.Session;
import net.runeduniverse.lib.rogm.logging.PipelineLogger;
import net.runeduniverse.lib.rogm.pipeline.APipelineFactory;
import net.runeduniverse.lib.rogm.pipeline.SessionWrapper;
import net.runeduniverse.lib.utils.chain.ChainManager;

public final class Pipeline
implements AutoCloseable {
    private final APipelineFactory<?> factory;
    private final ChainManager chain;
    private final PipelineLogger logger;
    private boolean setupMissing = true;
    private Set<Session> activeSessions = new HashSet<Session>();

    public Pipeline(APipelineFactory<?> pipelineFactory) {
        this.factory = pipelineFactory;
        this.logger = new PipelineLogger(Pipeline.class, (Logger)this.factory.getLogger());
        this.chain = new ChainManager((Logger)((Object)this.logger));
    }

    public Session buildSession() throws Exception {
        if (this.setupMissing) {
            this.factory.setup(this, this.chain);
            this.setupMissing = false;
        }
        return this.factory.buildSession();
    }

    @Deprecated
    public void registerActiveSession(Session session) {
        this.activeSessions.add(session);
    }

    @Override
    public void close() throws Exception {
        this.factory.closeConnections();
    }

    public void closeConnections(SessionWrapper sessionWrapper) throws Exception {
        this.activeSessions.remove(sessionWrapper);
        if (this.activeSessions.isEmpty()) {
            this.close();
        }
    }

    public PipelineLogger getLogger() {
        return this.logger;
    }
}

