/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline;

import java.util.Collection;
import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.lang.DatabaseCleaner;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.parser.Parser;
import net.runeduniverse.lib.rogm.pipeline.AChainRouter;
import net.runeduniverse.lib.rogm.pipeline.chain.data.DepthContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityCollectionContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.IdContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.LazyEntriesContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.utils.logging.UniversalLogger;

public class DatabaseChainRouter
extends AChainRouter {
    protected IBuffer buffer;
    protected DatabaseCleaner dbCleaner;
    protected Parser.Instance parserInstance;
    protected Language.Instance langInstance;
    protected Module.Instance<?> moduleInstance;

    public DatabaseChainRouter() {
        this((Logger)null);
    }

    public DatabaseChainRouter(Logger parent) {
        super(new UniversalLogger(DatabaseChainRouter.class, null));
    }

    public DatabaseChainRouter initialize(IBuffer buffer, DatabaseCleaner dbCleaner, Parser.Instance parserInstance, Language.Instance langInstance, Module.Instance<?> moduleInstance) {
        this.buffer = buffer;
        this.dbCleaner = dbCleaner;
        this.parserInstance = parserInstance;
        this.langInstance = langInstance;
        this.moduleInstance = moduleInstance;
        this.baseChainParamPool.add(this.buffer);
        this.baseChainParamPool.add(this.parserInstance);
        this.baseChainParamPool.add(this.langInstance);
        this.baseChainParamPool.add(this.moduleInstance);
        return this;
    }

    @Override
    public <E> E load(Class<E> entityType, IFilter filter, IdContainer id, DepthContainer depth) throws Exception {
        return super.callChain("LOAD_CHAIN.ONE", entityType, filter, id, depth, new LazyEntriesContainer());
    }

    @Override
    public <E> Collection<E> loadAll(Class<E> entityType, IFilter filter, DepthContainer depth) throws Exception {
        return super.callChain("LOAD_CHAIN.ALL", Collection.class, filter, depth, new LazyEntriesContainer());
    }

    @Override
    public void resolveAllLazyLoaded(Collection<? extends Object> entities, DepthContainer depth) throws Exception {
        LazyEntriesContainer lazyEntries = new LazyEntriesContainer();
        for (Object object : entities) {
            BufferTypes.IEntry entry = this.buffer.getEntry(object);
            if (entry == null || entry.getLoadState() == BufferTypes.LoadState.COMPLETE) continue;
            lazyEntries.addEntry(entry);
        }
        super.callChain("LOAD_CHAIN.RESOLVE_LAZY.ALL", Collection.class, lazyEntries, depth);
    }

    @Override
    public void reloadAll(Collection<Object> entities, DepthContainer depth) throws Exception {
        super.callChain("RELOAD_CHAIN.ALL", Void.class, new EntityCollectionContainer(entities), depth);
    }

    @Override
    public void save(EntityContainer entity, SaveContainer container, DepthContainer depth) throws Exception {
        super.callChain("SAVE_CHAIN.ONE", Void.class, this.dbCleaner, entity, container, depth);
    }

    @Override
    public void delete(EntityContainer entity, DepthContainer depth) throws Exception {
        super.callChain("DELETE_CHAIN.ONE", Void.class, entity, depth);
    }

    @Override
    public void unload(Object entity) {
        this.buffer.removeEntry(entity);
    }
}

