/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline;

import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.Session;
import net.runeduniverse.lib.rogm.errors.ScannerException;
import net.runeduniverse.lib.rogm.info.PackageInfo;
import net.runeduniverse.lib.rogm.info.SessionInfo;
import net.runeduniverse.lib.rogm.modules.IdTypeResolver;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pipeline.AChainRouter;
import net.runeduniverse.lib.rogm.pipeline.Pipeline;
import net.runeduniverse.lib.rogm.pipeline.SessionWrapper;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.utils.chain.ChainManager;
import net.runeduniverse.lib.utils.logging.UniversalLogger;

public abstract class APipelineFactory<ROUTER extends AChainRouter> {
    protected final Archive archive;
    protected final ROUTER router;
    protected final UniversalLogger logger;
    protected Pipeline pipeline = null;
    protected ChainManager chainManager = null;

    protected APipelineFactory(PackageInfo pkgInfo, IdTypeResolver idTypeResolver, ROUTER router, UniversalLogger logger) {
        this.archive = new Archive(pkgInfo, idTypeResolver);
        this.router = router;
        ((AChainRouter)router).initialize(this.archive);
        this.logger = logger;
    }

    public void setup(Pipeline pipeline, ChainManager chainManager) throws Exception {
        this.pipeline = pipeline;
        this.chainManager = chainManager;
        this.setupCallOrder();
    }

    protected void setupCallOrder() throws Exception {
        this.setupChainManager(this.chainManager);
        ((AChainRouter)this.router).setChainManager(this.chainManager);
        this.setupArchive(this.archive);
        this.archive.logPatterns((Logger)this.logger);
    }

    protected abstract void setupArchive(Archive var1) throws ScannerException;

    protected abstract void setupChainManager(ChainManager var1) throws Exception;

    public Session buildSession() {
        SessionWrapper wrapper = new SessionWrapper(this.pipeline, this, this.pipeline.getLogger(), this.getSessionInfo());
        this.pipeline.registerActiveSession(wrapper);
        return wrapper;
    }

    public abstract boolean isConnected();

    public abstract void closeConnections();

    protected void finalize() throws Throwable {
        this.closeConnections();
        super.finalize();
    }

    public UniversalLogger getLogger() {
        return this.logger;
    }

    public abstract SessionInfo getSessionInfo();

    public QueryBuilder getQueryBuilder() {
        return this.archive.getQueryBuilder();
    }

    public ROUTER getRouter() {
        return this.router;
    }
}

