/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pipeline;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.DepthContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.IdContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.utils.chain.ChainManager;
import net.runeduniverse.lib.utils.logging.UniversalLogger;

public abstract class AChainRouter {
    protected final Set<Object> baseChainParamPool = new HashSet<Object>();
    protected final UniversalLogger logger;
    protected Archive archive;
    protected ChainManager manager;

    protected AChainRouter() {
        this(new UniversalLogger(AChainRouter.class, null));
    }

    protected AChainRouter(UniversalLogger logger) {
        this.logger = logger;
        this.baseChainParamPool.add(logger);
    }

    public AChainRouter initialize(Archive archive) {
        this.archive = archive;
        this.baseChainParamPool.add(this.archive);
        return this;
    }

    public void setChainManager(ChainManager manager) {
        this.manager = manager;
    }

    public abstract <E> E load(Class<E> var1, IFilter var2, IdContainer var3, DepthContainer var4) throws Exception;

    public abstract <E> Collection<E> loadAll(Class<E> var1, IFilter var2, DepthContainer var3) throws Exception;

    public abstract void resolveAllLazyLoaded(Collection<? extends Object> var1, DepthContainer var2) throws Exception;

    public abstract void reloadAll(Collection<Object> var1, DepthContainer var2) throws Exception;

    public abstract void save(EntityContainer var1, SaveContainer var2, DepthContainer var3) throws Exception;

    public abstract void delete(EntityContainer var1, DepthContainer var2) throws Exception;

    public abstract void unload(Object var1);

    protected <R> R callChain(String label, Class<R> resultType, Object ... args) throws Exception {
        int size = this.baseChainParamPool.size();
        Object[] arr = new Object[size + args.length];
        this.baseChainParamPool.toArray(arr);
        for (int i = 0; i < args.length; ++i) {
            arr[size + i] = args[i];
        }
        return (R)this.manager.callChain(label, resultType, arr);
    }

    public <E> E load(IFilter filter) throws Exception {
        return (E)this.load(AChainRouter.getEntityOrObjectType(filter), filter, null, new DepthContainer(1));
    }

    public <E> Collection<E> loadAll(IFilter filter) throws Exception {
        return this.loadAll(null, filter, new DepthContainer(1));
    }

    public <E> E load(Class<E> entityType, int depth) throws Exception {
        return this.load(entityType, this.archive.search(entityType, depth == 0).getResult(), null, new DepthContainer(depth));
    }

    public <E> E load(Class<E> entityType, Serializable id, int depth) throws Exception {
        return this.load(entityType, this.archive.search(entityType, id, depth == 0).getResult(), new IdContainer(id), new DepthContainer(depth));
    }

    public <E> Collection<E> loadAll(Class<E> entityType, int depth) throws Exception {
        return this.loadAll(entityType, this.archive.search(entityType, depth == 0).getResult(), new DepthContainer(depth));
    }

    public <E> Collection<E> loadAll(Class<E> entityType, Serializable id, int depth) throws Exception {
        return this.loadAll(entityType, this.archive.search(entityType, id, depth == 0).getResult(), new DepthContainer(depth));
    }

    public void resolveAllLazyLoaded(Collection<? extends Object> entities, int depth) throws Exception {
        this.resolveAllLazyLoaded(entities, new DepthContainer(depth));
    }

    public void reloadAll(Collection<Object> entities, int depth) throws Exception {
        this.reloadAll(entities, new DepthContainer(depth));
    }

    public void save(Object entity, int depth) throws Exception {
        if (entity == null) {
            return;
        }
        this.save(new EntityContainer(entity), this.archive.save(entity.getClass(), entity, depth), new DepthContainer(depth));
    }

    public void delete(Object entity, int depth) throws Exception {
        if (entity == null) {
            return;
        }
        this.delete(new EntityContainer(entity), new DepthContainer(depth));
    }

    protected static Class<?> getEntityOrObjectType(IFilter filter) {
        if (filter instanceof IPattern.IPatternContainer) {
            return ((IPattern.IPatternContainer)filter).getPattern().getType();
        }
        return Object.class;
    }
}

