/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pattern.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import net.runeduniverse.lib.rogm.annotations.Converter;
import net.runeduniverse.lib.rogm.annotations.Id;
import net.runeduniverse.lib.rogm.annotations.NodeEntity;
import net.runeduniverse.lib.rogm.annotations.PostDelete;
import net.runeduniverse.lib.rogm.annotations.PostLoad;
import net.runeduniverse.lib.rogm.annotations.PostReload;
import net.runeduniverse.lib.rogm.annotations.PostSave;
import net.runeduniverse.lib.rogm.annotations.PreDelete;
import net.runeduniverse.lib.rogm.annotations.PreReload;
import net.runeduniverse.lib.rogm.annotations.PreSave;
import net.runeduniverse.lib.rogm.annotations.Relationship;
import net.runeduniverse.lib.rogm.annotations.RelationshipEntity;
import net.runeduniverse.lib.rogm.annotations.StartNode;
import net.runeduniverse.lib.rogm.annotations.TargetNode;
import net.runeduniverse.lib.rogm.pattern.APattern;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.FieldPattern;
import net.runeduniverse.lib.rogm.pattern.NodePattern;
import net.runeduniverse.lib.rogm.pattern.RelationPattern;
import net.runeduniverse.lib.rogm.pattern.scanner.FieldAnnoScanner;
import net.runeduniverse.lib.rogm.pattern.scanner.RelatedFieldAnnoScanner;
import net.runeduniverse.lib.utils.scanner.IFieldScanner;
import net.runeduniverse.lib.utils.scanner.IMethodScanner;
import net.runeduniverse.lib.utils.scanner.ScanOrder;
import net.runeduniverse.lib.utils.scanner.pattern.MethodPattern;
import net.runeduniverse.lib.utils.scanner.templates.MethodAnnotationScanner;
import net.runeduniverse.lib.utils.scanner.templates.TypeAnnotationScanner;
import net.runeduniverse.lib.utils.scanner.templates.TypeScanner;

public class TypeScanner
extends TypeAnnotationScanner<FieldPattern, MethodPattern, APattern<?>> {
    protected final Archive archive;

    public TypeScanner(Archive archive, TypeScanner.PatternCreator<FieldPattern, MethodPattern, APattern<?>> creator2, Class<? extends Annotation> anno, TypeScanner.ResultConsumer<FieldPattern, MethodPattern, APattern<?>> consumer) {
        super(anno, creator2, consumer);
        this.archive = archive;
        this.addFieldScanner((IFieldScanner)new FieldAnnoScanner(archive, Id.class, ScanOrder.FIRST));
        this.addFieldScanner((IFieldScanner)new FieldAnnoScanner(archive, Converter.class, ScanOrder.ALL));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PreReload.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PreSave.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PreDelete.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PostLoad.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PostReload.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PostSave.class, (ScanOrder)ScanOrder.FIRST));
        this.addFieldScanner((IMethodScanner)MethodAnnotationScanner.DEFAULT(PostDelete.class, (ScanOrder)ScanOrder.FIRST));
    }

    public void scan(Class<?> type, ClassLoader loader, String pkg) throws Exception {
        if (Modifier.isAbstract(type.getModifiers())) {
            return;
        }
        super.scan(type, loader, pkg);
    }

    public static class RelationScanner
    extends TypeScanner {
        public RelationScanner(Archive archive, TypeScanner.ResultConsumer<FieldPattern, MethodPattern, APattern<?>> consumer) {
            super(archive, (type, loader, pkg) -> new RelationPattern(archive, pkg, loader, type), RelationshipEntity.class, consumer);
            this.addFieldScanner((IFieldScanner)new FieldAnnoScanner(archive, StartNode.class, ScanOrder.FIRST));
            this.addFieldScanner((IFieldScanner)new FieldAnnoScanner(archive, TargetNode.class, ScanOrder.FIRST));
        }
    }

    public static class NodeScanner
    extends TypeScanner {
        public NodeScanner(Archive archive, TypeScanner.ResultConsumer<FieldPattern, MethodPattern, APattern<?>> consumer) {
            super(archive, (type, loader, pkg) -> new NodePattern(archive, pkg, loader, type), NodeEntity.class, consumer);
            this.addFieldScanner((IFieldScanner)new RelatedFieldAnnoScanner(archive, Relationship.class, ScanOrder.FIRST));
        }
    }
}

