/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pattern;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.annotations.PreDelete;
import net.runeduniverse.lib.rogm.annotations.PreSave;
import net.runeduniverse.lib.rogm.annotations.RelationshipEntity;
import net.runeduniverse.lib.rogm.annotations.StartNode;
import net.runeduniverse.lib.rogm.annotations.TargetNode;
import net.runeduniverse.lib.rogm.pattern.APattern;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.FieldPattern;
import net.runeduniverse.lib.rogm.pattern.INodePattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pattern.IRelationPattern;
import net.runeduniverse.lib.rogm.pattern.NodePattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.querying.IDataContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.utils.common.StringUtils;

public class RelationPattern
extends APattern<QueryBuilder.RelationQueryBuilder>
implements IRelationPattern<QueryBuilder.RelationQueryBuilder> {
    private String label = null;
    private Direction direction = null;
    private FieldPattern startField = null;
    private FieldPattern targetField = null;
    private boolean stEqTr = false;
    private boolean readonlyStart = false;
    private boolean readonlyTarget = false;

    public RelationPattern(Archive archive, String pkg, ClassLoader loader, Class<?> type) {
        super(archive, pkg, loader, type);
        RelationshipEntity typeAnno = this.type.getAnnotation(RelationshipEntity.class);
        this.direction = typeAnno.direction();
        this.label = typeAnno.label();
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        this.startField = (FieldPattern)super.getField(StartNode.class);
        if (this.startField == null) {
            throw new Exception("Relation<" + this.type + "> is missing the @StartNode");
        }
        if (Collection.class.isAssignableFrom(this.startField.getType())) {
            throw new Exception("@StartNode of Relation<" + this.type + "> must not be a Collection");
        }
        this.targetField = (FieldPattern)super.getField(TargetNode.class);
        if (this.targetField == null) {
            throw new Exception("Relation<" + this.type + "> is missing the @TargetNode");
        }
        if (Collection.class.isAssignableFrom(this.targetField.getType())) {
            throw new Exception("@TargetNode of Relation<" + this.type + "> must not be a Collection");
        }
        StartNode startAnno = (StartNode)this.startField.getAnno(StartNode.class);
        TargetNode targetAnno = (TargetNode)this.targetField.getAnno(TargetNode.class);
        if (this.startField.getField() == this.targetField.getField()) {
            this.stEqTr = true;
        }
        this.readonlyStart = startAnno.readonly();
        this.readonlyTarget = targetAnno.readonly();
    }

    @Override
    public IPattern.PatternType getPatternType() {
        return IPattern.PatternType.RELATION;
    }

    @Override
    public Collection<String> getLabels() {
        return Arrays.asList(this.label);
    }

    @Override
    public QueryBuilder.RelationQueryBuilder search(boolean lazy) {
        return this.completeSearch((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(this.direction).setLazy(lazy));
    }

    @Override
    public QueryBuilder.RelationQueryBuilder search(Serializable id, boolean lazy) throws Exception {
        return this.completeSearch((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(this.direction).whereId(id)).setLazy(lazy));
    }

    @Override
    public QueryBuilder.RelationQueryBuilder completeSearch(QueryBuilder.RelationQueryBuilder relationBuilder) {
        boolean lazy = relationBuilder.isLazy();
        if (!StringUtils.isBlank((String)this.label)) {
            relationBuilder.getLabels().add(this.label);
        }
        if (this.stEqTr) {
            QueryBuilder.NodeQueryBuilder nodeBuilder = this._getNode(this.startField.getType(), relationBuilder, lazy);
            return relationBuilder.setStart(nodeBuilder).setTarget(nodeBuilder);
        }
        return (QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)relationBuilder.setStart(this._getNode(this.startField.getType(), relationBuilder, lazy)).setTarget(this._getNode(this.targetField.getType(), relationBuilder, lazy)).storePattern(this)).setReturned(true);
    }

    @Override
    public QueryBuilder.RelationQueryBuilder createFilter(QueryBuilder.NodeQueryBuilder caller, Direction direction) {
        QueryBuilder.RelationQueryBuilder relationBuilder = (QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(this.direction).storePattern(this);
        if (!StringUtils.isBlank((String)this.label)) {
            relationBuilder.getLabels().add(this.label);
        }
        if (this.stEqTr) {
            return relationBuilder.setStart(caller).setTarget(caller);
        }
        if (this.direction == Direction.OUTGOING && direction == Direction.INCOMING || this.direction == Direction.INCOMING && direction == Direction.OUTGOING) {
            relationBuilder.setTarget(caller).setStart(this._getNode(this.startField.getType(), relationBuilder, true));
        } else {
            relationBuilder.setStart(caller).setTarget(this._getNode(this.targetField.getType(), relationBuilder, true));
        }
        return relationBuilder;
    }

    @Override
    public SaveContainer save(Object entity, Integer depth) throws Exception {
        return new SaveContainer(includedData -> (IDataContainer)this.save(entity, null, this.direction, includedData, depth).getResult());
    }

    @Override
    public IPattern.IDeleteContainer delete(Serializable id, Object entity) throws Exception {
        this.archive.callMethod(entity.getClass(), PreDelete.class, entity, new Object[0]);
        return new APattern.DeleteContainer(this, entity, id, null, (IFilter)((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(Direction.BIDIRECTIONAL).whereId(id)).setReturned(true)).getResult());
    }

    @Override
    public QueryBuilder.RelationQueryBuilder save(Object entity, QueryBuilder.NodeQueryBuilder caller, Direction direction, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData, Integer depth) throws Exception {
        if (entity == null || this.startField.getValue(entity) == null || this.targetField.getValue(entity) == null) {
            return null;
        }
        if (includedData.containsKey(entity)) {
            return (QueryBuilder.RelationQueryBuilder)includedData.get(entity);
        }
        this.callMethod(PreSave.class, entity, new Object[0]);
        QueryBuilder.RelationQueryBuilder relationBuilder = (QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(this.direction).storeData(entity)).setReturned(true);
        if (this.isIdSet(entity)) {
            relationBuilder.asUpdate();
        } else {
            relationBuilder.asWrite();
        }
        includedData.put(entity, relationBuilder);
        if (!StringUtils.isBlank((String)this.label)) {
            relationBuilder.getLabels().add(this.label);
        }
        if (caller == null) {
            caller = this._getDataNode(this.startField, entity, includedData, relationBuilder, depth);
            relationBuilder.setStart(caller);
            if (this.stEqTr) {
                relationBuilder.setTarget(caller);
            } else {
                relationBuilder.setTarget(this._getDataNode(this.targetField, entity, includedData, relationBuilder, depth));
            }
            return this._savecheck(relationBuilder);
        }
        if (this.stEqTr) {
            relationBuilder.setStart(caller).setTarget(caller);
            return this._savecheck(relationBuilder);
        }
        if (this.direction == Direction.OUTGOING && direction == Direction.INCOMING || this.direction == Direction.INCOMING && direction == Direction.OUTGOING) {
            relationBuilder.setStart(this._getDataNode(this.startField, entity, includedData, relationBuilder, this.readonlyStart ? -1 : depth));
            relationBuilder.setTarget(caller);
        } else {
            relationBuilder.setStart(caller);
            relationBuilder.setTarget(this._getDataNode(this.targetField, entity, includedData, relationBuilder, this.readonlyTarget ? -1 : depth));
        }
        return this._savecheck(relationBuilder);
    }

    private QueryBuilder.RelationQueryBuilder _savecheck(QueryBuilder.RelationQueryBuilder relationBuilder) {
        if (relationBuilder.getStart() == null || relationBuilder.getTarget() == null) {
            return null;
        }
        return relationBuilder;
    }

    public void setStart(Object entity, Object value) {
        try {
            this.startField.setValue(entity, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setTarget(Object entity, Object value) {
        try {
            this.targetField.setValue(entity, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private QueryBuilder.NodeQueryBuilder _getNode(Class<?> type, QueryBuilder.RelationQueryBuilder relation, boolean lazy) {
        INodePattern node = this.archive.getPattern(type, NodePattern.class);
        if (node == null) {
            return null;
        }
        return node.search(relation, lazy);
    }

    private QueryBuilder.NodeQueryBuilder _getDataNode(FieldPattern field, Object entity, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData, QueryBuilder.RelationQueryBuilder relation, Integer depth) throws Exception {
        INodePattern node = this.archive.getPattern((Class<?>)field.getType(), NodePattern.class);
        if (node == null) {
            throw new Exception("NodePattern for Field<" + field.toString() + "> undefined!");
        }
        QueryBuilder.NodeQueryBuilder nodeBuilder = node.save(field.getValue(entity), includedData, depth);
        nodeBuilder.addRelation(relation);
        return nodeBuilder;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isStEqTr() {
        return this.stEqTr;
    }
}

