/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pattern;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.annotations.NodeEntity;
import net.runeduniverse.lib.rogm.annotations.Relationship;
import net.runeduniverse.lib.rogm.annotations.RelationshipEntity;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.FieldPattern;
import net.runeduniverse.lib.rogm.pattern.INodePattern;
import net.runeduniverse.lib.rogm.pattern.IRelationPattern;
import net.runeduniverse.lib.rogm.pattern.IValidatable;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.utils.common.StringUtils;

public class RelatedFieldPattern
extends FieldPattern
implements IValidatable {
    private String label = null;
    private Direction direction;
    private boolean definedRelation;

    public RelatedFieldPattern(Archive archive, Field field) throws Exception {
        super(archive, field);
    }

    @Override
    public void validate() throws Exception {
        Relationship fieldAnno = this.field.getAnnotation(Relationship.class);
        this.direction = fieldAnno.direction();
        if (this.type.isAnnotationPresent(NodeEntity.class)) {
            this.definedRelation = false;
        } else if (this.type.isAnnotationPresent(RelationshipEntity.class)) {
            this.label = this.archive.getPattern((Class<?>)this.type, IRelationPattern.class).getLabel();
            this.definedRelation = true;
        } else {
            throw new Exception("Unsupported Class<" + this.type.getName() + "> as @Relation found!");
        }
        if (StringUtils.isBlank((String)this.label)) {
            this.label = StringUtils.isBlank((String)fieldAnno.label()) ? this.field.getName() : fieldAnno.label();
        }
    }

    public QueryBuilder.RelationQueryBuilder queryRelation(QueryBuilder.NodeQueryBuilder origin) throws Exception {
        QueryBuilder.RelationQueryBuilder relationBuilder = null;
        if (this.definedRelation) {
            relationBuilder = this.archive.getPattern((Class<?>)this.type, IRelationPattern.class).createFilter(origin, this.direction);
        } else {
            relationBuilder = this.archive.getQueryBuilder().relation().whereDirection(this.direction);
            relationBuilder.setStart(origin);
            relationBuilder.setTarget(this._getNode(this.type, relationBuilder));
        }
        if (relationBuilder.getLabels().isEmpty()) {
            relationBuilder.getLabels().add(this.label);
        }
        relationBuilder.setReturned(true);
        relationBuilder.setOptional(true);
        return relationBuilder;
    }

    private QueryBuilder.NodeQueryBuilder _getNode(Class<?> type, QueryBuilder.RelationQueryBuilder relation) throws Exception {
        INodePattern node = this.archive.getPattern(type, INodePattern.class);
        if (node == null) {
            throw new Exception("Unsupported Class<" + type.getName() + "> as @Relation found!");
        }
        return node.search(relation, true);
    }

    public void saveRelation(Object entity, QueryBuilder.NodeQueryBuilder nodeBuilder, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData, Integer depth) throws Exception {
        if (entity == null) {
            return;
        }
        if (this.collection) {
            for (Object relNode : (Collection)this.field.get(entity)) {
                this._addRelation(nodeBuilder, relNode, includedData, depth);
            }
        } else {
            this._addRelation(nodeBuilder, this.field.get(entity), includedData, depth);
        }
    }

    private void _addRelation(QueryBuilder.NodeQueryBuilder nodeBuilder, Object relEntity, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData, Integer depth) throws Exception {
        if (relEntity == null) {
            return;
        }
        QueryBuilder.RelationQueryBuilder relationBuilder = null;
        Class<?> clazz = relEntity.getClass();
        if (clazz.isAnnotationPresent(RelationshipEntity.class)) {
            relationBuilder = this.archive.getPattern(clazz, IRelationPattern.class).save(relEntity, nodeBuilder, this.direction, includedData, depth);
            if (relationBuilder == null) {
                return;
            }
        } else {
            relationBuilder = (QueryBuilder.RelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.archive.getQueryBuilder().relation().setAutoGenerated(true)).whereDirection(this.direction).setStart(nodeBuilder).setTarget(this.archive.getPattern(clazz, INodePattern.class).save(relEntity, includedData, depth)).asUpdate();
        }
        if (relationBuilder.getLabels().isEmpty()) {
            relationBuilder.getLabels().add(this.label);
        }
        nodeBuilder.addRelation(relationBuilder);
    }

    public String getLabel() {
        return this.label;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isDefinedRelation() {
        return this.definedRelation;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setDefinedRelation(boolean definedRelation) {
        this.definedRelation = definedRelation;
    }
}

