/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pattern;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.annotations.NodeEntity;
import net.runeduniverse.lib.rogm.annotations.PreDelete;
import net.runeduniverse.lib.rogm.annotations.PreSave;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.pattern.APattern;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.FieldPattern;
import net.runeduniverse.lib.rogm.pattern.INodePattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pattern.RelatedFieldPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.querying.IDataContainer;
import net.runeduniverse.lib.rogm.querying.IFRelation;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.utils.common.StringUtils;

public class NodePattern
extends APattern<QueryBuilder.NodeQueryBuilder>
implements INodePattern<QueryBuilder.NodeQueryBuilder>,
BufferTypes {
    private Set<String> labels = new HashSet<String>();
    private Set<RelatedFieldPattern> relFields = new HashSet<RelatedFieldPattern>();

    public NodePattern(Archive archive, String pkg, ClassLoader loader, Class<?> type) {
        super(archive, pkg, loader, type);
        NodeEntity typeAnno = type.getAnnotation(NodeEntity.class);
        String label = null;
        if (typeAnno != null) {
            label = typeAnno.label();
        }
        if (StringUtils.isBlank(label) && !Modifier.isAbstract(type.getModifiers())) {
            label = type.getSimpleName();
        }
        if (!StringUtils.isBlank((String)label)) {
            this.labels.add(label);
        }
    }

    @Override
    public void validate() throws Exception {
        for (FieldPattern fieldPattern : this.fields.values()) {
            if (!(fieldPattern instanceof RelatedFieldPattern)) continue;
            this.relFields.add((RelatedFieldPattern)fieldPattern);
        }
        super.validate();
    }

    @Override
    public IPattern.PatternType getPatternType() {
        return IPattern.PatternType.NODE;
    }

    @Override
    public QueryBuilder.NodeQueryBuilder search(boolean lazy) throws Exception {
        return this.completeSearch((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)this.archive.getQueryBuilder().node().setAutoGenerated(true)).where(this.type)).setLazy(lazy).setReturned(true));
    }

    @Override
    public QueryBuilder.NodeQueryBuilder search(Serializable id, boolean lazy) throws Exception {
        return this.completeSearch((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)this.archive.getQueryBuilder().node().setAutoGenerated(true)).where(this.type)).whereId(id)).setLazy(lazy).setReturned(true));
    }

    @Override
    @Deprecated
    public QueryBuilder.NodeQueryBuilder search(QueryBuilder.RelationQueryBuilder caller, boolean lazy) {
        QueryBuilder.NodeQueryBuilder nodeBuilder = ((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)this.archive.getQueryBuilder().node().setAutoGenerated(true)).where(this.type)).setReturned(true)).setOptional(true)).setLazy(lazy).addRelation(caller);
        try {
            return this.completeSearch(nodeBuilder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return nodeBuilder;
        }
    }

    @Override
    public QueryBuilder.NodeQueryBuilder completeSearch(QueryBuilder.NodeQueryBuilder nodeBuilder) throws Exception {
        nodeBuilder.storePattern(this);
        if (!nodeBuilder.isLazy()) {
            for (RelatedFieldPattern field : this.relFields) {
                nodeBuilder.addRelation(field.queryRelation(nodeBuilder));
            }
        }
        return nodeBuilder;
    }

    @Override
    public SaveContainer save(Object entity, Integer depth) throws Exception {
        return new SaveContainer(includedData -> (IDataContainer)this.save(entity, includedData, depth).getResult(), NodePattern::calcEffectedFilters);
    }

    private static final Set<IFilter> calcEffectedFilters(Archive archive, IBuffer buffer, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData) throws Exception {
        HashSet<IFilter> set = new HashSet<IFilter>();
        for (Object object : includedData.keySet()) {
            BufferTypes.IEntry entry;
            if (!includedData.get(object).persist() || (entry = buffer.getEntry(object)) == null || entry.getLoadState() == BufferTypes.LoadState.LAZY) continue;
            set.add(archive.search(entry.getType(), entry.getId(), false).getResult());
        }
        return set;
    }

    @Override
    public QueryBuilder.NodeQueryBuilder save(Object entity, Map<Object, IQueryBuilder<?, ?, ? extends IFilter>> includedData, Integer depth) throws Exception {
        if (entity == null) {
            return null;
        }
        boolean readonly = depth == -1;
        boolean persist = 0 < depth;
        IQueryBuilder<?, ?, IFilter> container = includedData.get(entity);
        QueryBuilder.NodeQueryBuilder nodeBuilder = null;
        if (container != null) {
            if (readonly || !container.isReadonly()) {
                return (QueryBuilder.NodeQueryBuilder)container;
            }
            nodeBuilder = (QueryBuilder.NodeQueryBuilder)container;
        } else {
            nodeBuilder = (QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)this.archive.getQueryBuilder().node().where(this.type)).storeData(entity)).setPersist(persist);
            if (this.isIdSet(entity)) {
                ((QueryBuilder.NodeQueryBuilder)nodeBuilder.whereId(this.getId(entity))).asUpdate();
            } else {
                nodeBuilder.asWrite();
            }
        }
        this.callMethod(PreSave.class, entity, new Object[0]);
        ((QueryBuilder.NodeQueryBuilder)nodeBuilder.setReturned(true)).setReadonly(readonly);
        includedData.put(entity, nodeBuilder);
        if (persist) {
            depth = depth - 1;
            for (RelatedFieldPattern field : this.relFields) {
                field.saveRelation(entity, nodeBuilder, includedData, depth);
            }
        }
        return nodeBuilder;
    }

    @Override
    public IPattern.IDeleteContainer delete(Serializable id, Object entity) throws Exception {
        this.archive.callMethod(entity.getClass(), PreDelete.class, entity, new Object[0]);
        QueryBuilder qryBuilder = this.archive.getQueryBuilder();
        return new APattern.DeleteContainer(this, this, entity, id, (IFRelation)((QueryBuilder.RelationQueryBuilder)qryBuilder.relation().setStart((QueryBuilder.NodeQueryBuilder)qryBuilder.node().whereId(id)).setTarget((QueryBuilder.NodeQueryBuilder)qryBuilder.node().setReturned(true)).setReturned(true)).getResult(), (IFilter)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)qryBuilder.node().whereId(id)).setReturned(true)).asDelete()).getResult());
    }

    public void setRelation(Direction direction, String label, Object entity, Object value) {
        for (RelatedFieldPattern field : this.relFields) {
            if (!field.getDirection().equals((Object)direction) || !field.getLabel().equals(label) || !field.getType().isAssignableFrom(value.getClass())) continue;
            field.putValue(entity, value);
            return;
        }
    }

    public void deleteRelations(Object entity) {
        for (RelatedFieldPattern field : this.relFields) {
            field.clearValue(entity);
        }
    }

    @Override
    public void deleteRelations(Object entity, Collection<Object> delEntries) {
        for (RelatedFieldPattern field : this.relFields) {
            field.removeValues(entity, delEntries);
        }
    }

    public Set<String> getLabels() {
        return this.labels;
    }
}

