/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.pattern;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.annotations.IConverter;
import net.runeduniverse.lib.rogm.annotations.Id;
import net.runeduniverse.lib.rogm.errors.ScannerException;
import net.runeduniverse.lib.rogm.info.PackageInfo;
import net.runeduniverse.lib.rogm.modules.IdTypeResolver;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pattern.IQueryPattern;
import net.runeduniverse.lib.rogm.pattern.IValidatable;
import net.runeduniverse.lib.rogm.pattern.RelatedFieldPattern;
import net.runeduniverse.lib.rogm.pattern.scanner.TypeScanner;
import net.runeduniverse.lib.rogm.pipeline.chain.data.SaveContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.IQueryBuilder;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.utils.logging.Level;
import net.runeduniverse.lib.utils.logging.logs.CompoundTree;
import net.runeduniverse.lib.utils.scanner.PackageScanner;
import net.runeduniverse.lib.utils.scanner.pattern.FieldPattern;
import net.runeduniverse.lib.utils.scanner.pattern.MethodPattern;
import net.runeduniverse.lib.utils.scanner.pattern.TypePattern;

public final class Archive {
    public static boolean PACKAGE_SCANNER_DEBUG_MODE = false;
    private final Map<Class<?>, Set<IPattern>> patterns = new HashMap();
    private final Set<String> pkgs = new HashSet<String>();
    private final Set<ClassLoader> loader = new HashSet<ClassLoader>();
    private final PackageInfo info;
    private final IdTypeResolver idTypeResolver;
    private final QueryBuilder queryBuilder;
    private final PackageScanner.Validator validator = new PackageScanner.Validator(){

        public void validate() throws Exception {
            IValidatable.validate(Archive.this.patterns.values());
        }
    };

    public Archive(PackageInfo info, IdTypeResolver idTypeResolver) {
        this.info = info;
        this.pkgs.addAll(this.info.getPkgs());
        this.loader.addAll(this.info.getLoader());
        this.idTypeResolver = idTypeResolver;
        this.queryBuilder = new QueryBuilder(this);
    }

    public void scan(TypeScanner ... scanner) throws ScannerException {
        try {
            new PackageScanner().includeOptions(new Object[]{this.loader, this.pkgs, Arrays.asList(scanner), this.validator}).enableDebugMode(PACKAGE_SCANNER_DEBUG_MODE || this.info.getLoggingLevel() != null && this.info.getLoggingLevel().intValue() < Level.INFO.intValue()).scan().throwSurpressions();
        }
        catch (Exception e) {
            throw new ScannerException("Pattern parsing failed! See surpressed Exceptions!", e);
        }
    }

    public void addEntry(Class<?> type, IPattern pattern) {
        if (!this.patterns.containsKey(type)) {
            this.patterns.put(type, new HashSet());
        }
        this.patterns.get(type).add(pattern);
    }

    public void logPatterns(Logger logger) {
        CompoundTree tree = new CompoundTree((CharSequence)"Archive Pattern Dump");
        this.loader.forEach(l -> tree.append((CharSequence)"LOADER", (CharSequence)l.getClass().getCanonicalName()));
        this.patterns.forEach((c, patterns) -> {
            CompoundTree clazz = new CompoundTree((CharSequence)"CLASS", (CharSequence)c.getCanonicalName());
            patterns.forEach(p -> {
                if (p == null) {
                    return;
                }
                CompoundTree pattern = new CompoundTree((CharSequence)p.getPatternType().toString(), (CharSequence)p.getClass().getCanonicalName());
                if (p instanceof TypePattern) {
                    TypePattern tp = (TypePattern)p;
                    pattern.append((CharSequence)"PKG", (CharSequence)tp.getPkg()).append((CharSequence)"TYPE", (CharSequence)tp.getType().getCanonicalName()).append((CharSequence)"SUPER TYPE", (CharSequence)tp.getSuperType().getCanonicalName());
                    if (!p.getLabels().isEmpty()) {
                        pattern.append((CharSequence)"LABELS", (CharSequence)String.join((CharSequence)", ", p.getLabels()));
                    }
                    Archive.collectFields(tp).forEach((f, s) -> {
                        String label;
                        CompoundTree annos = new CompoundTree((CharSequence)"FIELD", (CharSequence)f.getClass().getCanonicalName()).append((CharSequence)"NAME", (CharSequence)f.getField().getName()).append((CharSequence)"TYPE", (CharSequence)f.getType().getCanonicalName());
                        if (f instanceof RelatedFieldPattern && (label = ((RelatedFieldPattern)f).getLabel()) != null) {
                            annos.append((CharSequence)"LABEL", (CharSequence)label);
                        }
                        s.forEach(a -> annos.append((CharSequence)"ANNO", (CharSequence)('@' + a.getSimpleName())));
                        pattern.append(annos);
                    });
                    Archive.collectMethods(tp).forEach((m, s) -> {
                        CompoundTree annos = new CompoundTree((CharSequence)"METHOD", (CharSequence)m.getMethod().getName());
                        s.forEach(a -> annos.append((CharSequence)"ANNO", (CharSequence)('@' + a.getSimpleName())));
                        pattern.append(annos);
                    });
                }
                clazz.append(pattern);
            });
            tree.append(clazz);
        });
        logger.config(tree.toString());
    }

    private static Map<FieldPattern, Set<Class<? extends Annotation>>> collectFields(TypePattern<?, ?> tp) {
        HashMap<FieldPattern, Set<Class<? extends Annotation>>> fields = new HashMap<FieldPattern, Set<Class<? extends Annotation>>>();
        tp.getFields().forEach((a, f) -> {
            if (a == null) {
                return;
            }
            HashSet<Class> s = (HashSet<Class>)fields.get(f);
            if (s == null) {
                s = new HashSet<Class>();
                fields.put((FieldPattern)f, (Set<Class<? extends Annotation>>)s);
            }
            s.add((Class)a);
        });
        return fields;
    }

    private static Map<MethodPattern, Set<Class<? extends Annotation>>> collectMethods(TypePattern<?, ?> tp) {
        HashMap<MethodPattern, Set<Class<? extends Annotation>>> methods = new HashMap<MethodPattern, Set<Class<? extends Annotation>>>();
        tp.getMethods().forEach((a, m) -> {
            if (a == null) {
                return;
            }
            HashSet<Class> s = (HashSet<Class>)methods.get(m);
            if (s == null) {
                s = new HashSet<Class>();
                methods.put((MethodPattern)m, (Set<Class<? extends Annotation>>)s);
            }
            s.add((Class)a);
        });
        return methods;
    }

    public Set<IPattern> getPatterns(Class<?> type) {
        return this.patterns.get(type);
    }

    public <P extends IPattern> Set<P> getPatterns(Class<?> entityType, Class<P> patternType) {
        HashSet<IPattern> rPatterns = new HashSet<IPattern>();
        for (IPattern pattern : this.patterns.get(entityType)) {
            if (!patternType.isInstance(pattern)) continue;
            rPatterns.add(pattern);
        }
        return rPatterns;
    }

    public <P extends IPattern> P getPattern(Class<?> entityType, Class<P> patternType) {
        if (this.patterns.containsKey(entityType)) {
            return this._getPattern(entityType, patternType);
        }
        for (Class<?> key : this.patterns.keySet()) {
            if (!entityType.isInstance(key)) continue;
            return this._getPattern(key, patternType);
        }
        return null;
    }

    public IPattern getPattern(Class<?> entityType, Class<?> ... patternTypes) {
        for (IPattern pattern : this.patterns.get(entityType)) {
            for (int i = 0; i < patternTypes.length; ++i) {
                if (!patternTypes[i].isInstance(pattern)) continue;
                return pattern;
            }
        }
        return null;
    }

    private <P extends IPattern> P _getPattern(Class<?> entityType, Class<P> patternType) {
        for (IPattern pattern : this.patterns.get(entityType)) {
            if (!patternType.isInstance(pattern)) continue;
            return (P)pattern;
        }
        return null;
    }

    public boolean isIdSet(Object entity) {
        try {
            return this.getPattern(entity.getClass(), (Class)IBaseQueryPattern.class).isIdSet(entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object setId(Object entity, Serializable id) {
        try {
            return this.getPattern(entity.getClass(), (Class)IBaseQueryPattern.class).setId(entity, id);
        }
        catch (Exception exception) {
            return entity;
        }
    }

    public IConverter<?> getIdFieldConverter(Class<?> type) {
        IConverter<?> converter = null;
        for (IPattern p : this.patterns.get(type)) {
            if (p.getField(Id.class) == null) continue;
            converter = p.getField(Id.class).getConverter();
            break;
        }
        return IConverter.validate(converter);
    }

    public boolean callMethod(Class<?> entityType, Class<? extends Annotation> anno, Object obj, Object ... args) {
        boolean success = true;
        for (IPattern pattern : this.patterns.get(entityType)) {
            if (pattern.callMethod(anno, obj, args)) continue;
            success = false;
        }
        return success;
    }

    public IQueryBuilder<?, ?, ? extends IFilter> search(Class<?> entityType, boolean lazy) throws Exception {
        Object builder = this.getPattern(entityType, (Class)IBaseQueryPattern.class).search(lazy);
        for (IQueryPattern pattern : this.getPatterns(entityType, IQueryPattern.class)) {
            pattern.search((IQueryBuilder<?, ?, ? extends IFilter>)builder);
        }
        return builder;
    }

    public IQueryBuilder<?, ?, ? extends IFilter> search(Class<?> entityType, Serializable id, boolean lazy) throws Exception {
        Object builder = this.getPattern(entityType, (Class)IBaseQueryPattern.class).search(id, lazy);
        for (IQueryPattern pattern : this.getPatterns(entityType, IQueryPattern.class)) {
            pattern.search((IQueryBuilder<?, ?, ? extends IFilter>)builder);
        }
        return builder;
    }

    public SaveContainer save(Class<?> entityType, Object entity, Integer depth) throws Exception {
        SaveContainer container = this.getPattern(entityType, (Class)IBaseQueryPattern.class).save(entity, depth);
        for (IQueryPattern pattern : this.getPatterns(entityType, IQueryPattern.class)) {
            pattern.save(container);
        }
        return container;
    }

    public IPattern.IDeleteContainer delete(Class<?> entityType, Serializable id, Object entity) throws Exception {
        IPattern.IDeleteContainer container = this.getPattern(entityType, (Class)IBaseQueryPattern.class).delete(id, entity);
        for (IQueryPattern pattern : this.getPatterns(entityType, IQueryPattern.class)) {
            pattern.delete(container);
        }
        return container;
    }

    public PackageInfo getInfo() {
        return this.info;
    }

    public IdTypeResolver getIdTypeResolver() {
        return this.idTypeResolver;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }
}

