/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.logging;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.info.SessionInfo;
import net.runeduniverse.lib.rogm.logging.PipelineLogger;
import net.runeduniverse.lib.utils.logging.ALogger;

public final class SessionLogger
extends ALogger {
    private static final AtomicLong id = new AtomicLong(0L);
    private final String prefix;

    public SessionLogger(Class<?> clazz, PipelineLogger pipelineLogger) {
        super("ROGM", null, (Logger)((Object)pipelineLogger));
        this.prefix = "[" + clazz.getSimpleName() + '|' + id.getAndIncrement() + "] ";
    }

    public void log(LogRecord record) {
        record.setMessage(this.prefix + record.getMessage());
        super.log(record);
    }

    public SessionLogger logSessionInfo(SessionInfo info) {
        super.log(Level.CONFIG, this.prefix + '\n' + info.toString());
        return this;
    }
}

