/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.info;

import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.info.ConnectionInfo;
import net.runeduniverse.lib.rogm.info.PackageInfo;
import net.runeduniverse.lib.rogm.pipeline.APipelineFactory;
import net.runeduniverse.lib.utils.logging.logs.CompoundTree;

public class SessionInfo {
    private final PackageInfo pkgInfo;
    private final ConnectionInfo[] conInfos;
    private final Class<? extends APipelineFactory<?>> builderClass;
    private final Class<? extends IBuffer> bufferClass;

    public SessionInfo(Class<? extends APipelineFactory<?>> builderClass, Class<? extends IBuffer> bufferClass, PackageInfo pkgInfo, ConnectionInfo ... conInfos) {
        this.pkgInfo = pkgInfo;
        this.conInfos = conInfos;
        this.builderClass = builderClass;
        this.bufferClass = bufferClass;
    }

    public String toString() {
        CompoundTree tree = new CompoundTree((CharSequence)"Initializing Session");
        tree.append(new CompoundTree((CharSequence)"PipelineFactory:").append((CharSequence)this.builderClass.getSimpleName()));
        tree.append(new CompoundTree((CharSequence)"Buffer:").append((CharSequence)this.bufferClass.getSimpleName()));
        CompoundTree pkgs = new CompoundTree((CharSequence)"Model Packages:");
        for (String p : this.pkgInfo.getPkgs()) {
            pkgs.append((CharSequence)p);
        }
        tree.append(pkgs);
        for (ConnectionInfo conInfo : this.conInfos) {
            tree.append(new CompoundTree((CharSequence)("Database Module: " + conInfo.getModule().getClass().getSimpleName())).append((CharSequence)("Uri:      " + conInfo.getUri())).append((CharSequence)("Protocol: " + conInfo.getProtocol())).append((CharSequence)("Port:     " + conInfo.getPort())).append((CharSequence)("User:     " + conInfo.getUser())));
        }
        return tree.toString();
    }

    public PackageInfo getPkgInfo() {
        return this.pkgInfo;
    }

    public ConnectionInfo[] getConInfos() {
        return this.conInfos;
    }

    public Class<? extends APipelineFactory<?>> getBuilderClass() {
        return this.builderClass;
    }

    public Class<? extends IBuffer> getBufferClass() {
        return this.bufferClass;
    }
}

