/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.info;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.runeduniverse.lib.rogm.Configuration;

public class PackageInfo {
    private final Set<String> pkgs = new HashSet<String>();
    private final Set<ClassLoader> loader = new HashSet<ClassLoader>();
    private Level loggingLevel = null;

    public PackageInfo(Configuration cnf) {
        this.pkgs.addAll(cnf.getPkgs());
        this.loader.addAll(cnf.getLoader());
        if (this.loggingLevel == null || this.loggingLevel.intValue() > cnf.getLoggingLevel().intValue()) {
            this.loggingLevel = cnf.getLoggingLevel();
        }
    }

    public PackageInfo merge(PackageInfo info) {
        this.pkgs.addAll(info.getPkgs());
        this.loader.addAll(info.getLoader());
        if (this.loggingLevel == null || this.loggingLevel.intValue() > info.getLoggingLevel().intValue()) {
            this.loggingLevel = info.getLoggingLevel();
        }
        return this;
    }

    public Set<String> getPkgs() {
        return this.pkgs;
    }

    public Set<ClassLoader> getLoader() {
        return this.loader;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public PackageInfo() {
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }
}

