/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.buffer;

import java.io.Serializable;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.LazyEntriesContainer;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.ILazyLoading;

public interface BufferTypes {

    public static enum LoadState {
        COMPLETE,
        LAZY;


        public static LoadState get(boolean lazy) {
            if (lazy) {
                return LAZY;
            }
            return COMPLETE;
        }

        public static LoadState get(IFilter filter) {
            return LoadState.get(filter instanceof ILazyLoading && ((ILazyLoading)filter).isLazy());
        }

        public static Object merge(IEntry entry, LoadState state, LazyEntriesContainer lazyEntries) {
            if (entry.getLoadState() == COMPLETE || state == COMPLETE) {
                entry.setLoadState(COMPLETE);
            } else {
                entry.setLoadState(LAZY);
                if (lazyEntries != null) {
                    lazyEntries.addEntry(entry);
                }
            }
            return entry.getEntity();
        }
    }

    public static interface IEntry {
        public Serializable getId();

        public Serializable getEntityId();

        public Object getEntity();

        public LoadState getLoadState();

        public Class<?> getType();

        public IBaseQueryPattern<?> getPattern();

        public void setId(Serializable var1);

        public void setEntityId(Serializable var1);

        public void setEntity(Object var1);

        public void setLoadState(LoadState var1);

        public void setType(Class<?> var1);

        public void setPattern(IBaseQueryPattern<?> var1);
    }
}

