/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.buffer;

import java.util.ArrayList;
import java.util.Collection;
import net.runeduniverse.lib.rogm.buffer.BasicBuffer;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.buffer.InternalBufferTypes;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.parser.Parser;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pattern.IPattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.DepthContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.EntityContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.IdContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.LazyEntriesContainer;
import net.runeduniverse.lib.rogm.pipeline.chain.data.UpdatedEntryContainer;
import net.runeduniverse.lib.utils.chain.Chain;
import net.runeduniverse.lib.utils.chain.ChainRuntime;
import net.runeduniverse.lib.utils.errors.ExceptionSuppressions;
import net.runeduniverse.lib.utils.logging.UniversalLogger;

public interface BasicBufferLayers
extends InternalBufferTypes {
    @Chain(label="LOAD_CHAIN.ONE", layers={0})
    public static <T> void ckeckBufferedStatus(ChainRuntime<T> runtime, IBuffer buffer, IdContainer id, DepthContainer depth) {
        if (id == null || id.getId() == null) {
            return;
        }
        Object o = depth.getValue() == 0 ? buffer.getByEntityId(id.getId(), runtime.getResultType()) : buffer.getCompleteByEntityId(id.getId(), runtime.getResultType());
        if (o != null) {
            runtime.setResult(o);
        }
    }

    @Chain(label="BUFFER_CHAIN.LOAD", layers={10})
    public static void prepareDataForBuffer(IBaseQueryPattern<?> pattern, IPattern.IData data) {
        pattern.prepareEntityId(data);
    }

    @Chain(label="BUFFER_CHAIN.LOAD", layers={20})
    public static Object acquireBuffered(ChainRuntime<?> runtime, BasicBuffer buffer, IBaseQueryPattern<?> pattern, IPattern.IData data, LazyEntriesContainer lazyEntries) throws Exception {
        InternalBufferTypes.Entry entry;
        BufferTypes.LoadState loadState = data.getLoadState();
        InternalBufferTypes.TypeEntry te = buffer.getTypeEntry(pattern.getType());
        if (te != null && (entry = te.getIdEntry(data.getId())) != null) {
            Object entity = BufferTypes.LoadState.merge(entry, loadState, lazyEntries);
            runtime.setPossibleResult(entity);
            return entity;
        }
        return null;
    }

    @Chain(label="BUFFER_CHAIN.LOAD", layers={30})
    public static EntityContainer parseData(Parser.Instance parser, IBaseQueryPattern<?> pattern, IPattern.IData data) throws Exception {
        return new EntityContainer(parser.deserialize(pattern.getType(), data.getData()));
    }

    @Chain(label="BUFFER_CHAIN.LOAD", layers={40})
    public static Object acquireNew(ChainRuntime<?> runtime, IBuffer buffer, UniversalLogger logger, IBaseQueryPattern<?> pattern, IPattern.IData data, LazyEntriesContainer lazyEntries, EntityContainer container) throws Exception {
        logger.finest("acquireNewObject for " + data);
        Object entity = container.getEntity();
        BufferTypes.LoadState loadState = data.getLoadState();
        pattern.setId(entity, data.getEntityId());
        InternalBufferTypes.Entry entry = new InternalBufferTypes.Entry(data, entity, loadState, pattern);
        if (lazyEntries != null && loadState == BufferTypes.LoadState.LAZY) {
            lazyEntries.addEntry(entry);
        }
        buffer.addEntry(entry);
        runtime.setPossibleResult(entity);
        return entity;
    }

    @Chain(label="DELETE_CHAIN.ONE", layers={100})
    public static BufferTypes.IEntry getBufferedEntry(ChainRuntime<?> runtime, IBuffer buffer, EntityContainer entity) throws Exception {
        BufferTypes.IEntry entry = buffer.getEntry(entity.getEntity());
        if (entry == null) {
            throw new Exception("Entity of type<" + entity.getType().getName() + "> is not loaded!");
        }
        return entry;
    }

    @Chain(label="BUFFER_CHAIN.UPDATE", layers={10})
    public static EntityContainer prepareDataReloadForBuffer(IBuffer buffer, IBaseQueryPattern<?> pattern, IPattern.IData data) {
        return new EntityContainer(pattern.prepareEntityUpdate(buffer, data));
    }

    @Chain(label="BUFFER_CHAIN.UPDATE", layers={20})
    public static void validateUpdate(ChainRuntime<?> runtime, EntityContainer entityContainer) throws Exception {
        if (entityContainer.getEntity() == null) {
            runtime.setCanceled(true);
        }
    }

    @Chain(label="BUFFER_CHAIN.UPDATE", layers={30})
    public static void parseDataToEntityContainerRef(Parser.Instance parser, EntityContainer entityContainer, IPattern.IData data) throws Exception {
        parser.deserialize(entityContainer.getEntity(), data.getData());
    }

    @Chain(label="BUFFER_CHAIN.UPDATE", layers={40})
    public static InternalBufferTypes.Entry updateBufferedEntry(ChainRuntime<InternalBufferTypes.Entry> runtime, BasicBuffer buffer, EntityContainer entityContainer, IPattern.IData data) throws Exception {
        Object entity = entityContainer.getEntity();
        InternalBufferTypes.Entry entry = buffer.getEntry(entity);
        buffer.updateEntry(entry, data.getId(), data.getEntityId());
        entry.getPattern().setId(entity, data.getEntityId());
        runtime.setResult((Object)entry);
        return entry;
    }

    @Chain(label="SAVE_CHAIN.ONE", layers={400})
    public static void updateBufferedEntries(Archive archive, IBuffer buffer, Collection<UpdatedEntryContainer> collection) throws ExceptionSuppressions {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (UpdatedEntryContainer updatedEntry : collection) {
            try {
                buffer.updateEntry(archive, updatedEntry);
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new ExceptionSuppressions("Surpressed Exceptions while updating buffered Ids", true).addSuppressed(errors);
        }
    }

    @Chain(label="DELETE_CHAIN.ONE", layers={500})
    public static void updateBuffer(IBuffer buffer, Language.IDeleteMapper mapper, IPattern.IDeleteContainer container, Module.IRawRecord record) {
        mapper.updateBuffer(buffer, container.getDeletedId(), record.getRawData());
    }
}

