/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.buffer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.runeduniverse.lib.rogm.annotations.PostDelete;
import net.runeduniverse.lib.rogm.buffer.BasicBufferLayers;
import net.runeduniverse.lib.rogm.buffer.BufferTypes;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.buffer.InternalBufferTypes;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.pattern.INodePattern;
import net.runeduniverse.lib.rogm.pipeline.chain.data.UpdatedEntryContainer;
import net.runeduniverse.lib.utils.chain.ChainManager;

public class BasicBuffer
implements IBuffer,
InternalBufferTypes {
    private Map<Object, InternalBufferTypes.Entry> entries = new HashMap<Object, InternalBufferTypes.Entry>();
    private Map<Class<?>, InternalBufferTypes.TypeEntry> typeMap = new HashMap();

    @Override
    public void setupChainManager(ChainManager chainManager) throws Exception {
        chainManager.addChainLayers(BasicBufferLayers.class);
    }

    @Override
    public <T> T getById(Serializable id, Class<T> type) {
        InternalBufferTypes.TypeEntry te = this.typeMap.get(type);
        if (te == null || te.idMap.get(id) == null) {
            return null;
        }
        return (T)te.idMap.get(id).getEntity();
    }

    @Override
    public <T> T getByEntityId(Serializable entityId, Class<T> type) {
        InternalBufferTypes.TypeEntry te = this.typeMap.get(type);
        if (te == null || te.entityIdMap.get(entityId) == null) {
            return null;
        }
        return (T)te.entityIdMap.get(entityId).getEntity();
    }

    @Override
    public <T> T getCompleteByEntityId(Serializable entityId, Class<T> type) {
        InternalBufferTypes.TypeEntry te = this.typeMap.get(type);
        if (te == null) {
            return null;
        }
        InternalBufferTypes.Entry entry = te.entityIdMap.get(entityId);
        if (entry == null || entry.getLoadState() == BufferTypes.LoadState.LAZY) {
            return null;
        }
        return (T)entry.getEntity();
    }

    @Override
    public void addEntry(BufferTypes.IEntry iEntry) {
        InternalBufferTypes.Entry entry = InternalBufferTypes.Entry.from(iEntry);
        InternalBufferTypes.TypeEntry te = this.typeMap.get(entry.getType());
        if (te == null) {
            te = new InternalBufferTypes.TypeEntry();
            this.typeMap.put(entry.getType(), te);
        }
        this.entries.put(entry.getEntity(), entry);
        te.idMap.put(entry.getId(), entry);
        te.entityIdMap.put(entry.getEntityId(), entry);
    }

    @Override
    public void addEntry(Serializable id, Serializable entityId, Object entity, BufferTypes.LoadState loadState, IBaseQueryPattern<?> pattern) {
        this.addEntry(new InternalBufferTypes.Entry(id, entityId, entity, loadState, entity.getClass(), pattern));
    }

    @Override
    public void updateEntry(Archive archive, UpdatedEntryContainer container) {
        Object entity = container.getEntity();
        if (entity == null) {
            return;
        }
        InternalBufferTypes.Entry entry = this.entries.get(entity);
        Class<?> type = entity.getClass();
        IBaseQueryPattern pattern = archive.getPattern(type, IBaseQueryPattern.class);
        pattern.prepareEntityId(container);
        if (entry == null) {
            this.addEntry(new InternalBufferTypes.Entry(container.getId(), container.getEntityId(), entity, container.getLoadState(), type, pattern));
        } else {
            this.updateEntry(entry, container.getId(), container.getEntityId());
        }
        pattern.setId(entity, container.getEntityId());
    }

    @Deprecated
    public void updateEntry(InternalBufferTypes.Entry entry, Serializable id, Serializable entityId) {
        InternalBufferTypes.TypeEntry te = this.typeMap.get(entry.getType());
        if (id != entry.getId()) {
            te.idMap.remove(entry.getId());
            entry.setId(id);
            te.idMap.put(id, entry);
        }
        if (entityId != entry.getEntityId()) {
            te.entityIdMap.remove(entry.getEntityId());
            entry.setEntityId(entityId);
            te.entityIdMap.put(entityId, entry);
        }
    }

    @Override
    public void removeEntry(BufferTypes.IEntry iEntry) {
        InternalBufferTypes.Entry entry = InternalBufferTypes.Entry.from(iEntry);
        if (entry == null) {
            return;
        }
        InternalBufferTypes.TypeEntry te = this.typeMap.get(entry.getType());
        if (te == null) {
            return;
        }
        te.idMap.remove(entry.getId());
        te.entityIdMap.remove(entry.getEntityId());
        this.entries.remove(entry.getEntity());
    }

    @Override
    public void removeEntry(Object entity) {
        this.removeEntry(this.entries.get(entity));
    }

    @Override
    public Collection<BufferTypes.IEntry> getAllEntries() {
        HashSet<BufferTypes.IEntry> values = new HashSet<BufferTypes.IEntry>();
        for (InternalBufferTypes.Entry entry : this.entries.values()) {
            values.add(entry);
        }
        return values;
    }

    @Deprecated
    public InternalBufferTypes.TypeEntry getTypeEntry(Class<?> type) {
        return this.typeMap.get(type);
    }

    @Override
    public InternalBufferTypes.Entry getEntry(Object entity) {
        return this.entries.get(entity);
    }

    @Override
    public void eraseRelations(Serializable deletedId, Serializable relationId, Serializable nodeId) {
        HashSet<InternalBufferTypes.Entry> deletedEntries = new HashSet<InternalBufferTypes.Entry>();
        HashSet<Object> deletedEntities = new HashSet<Object>();
        HashSet<InternalBufferTypes.Entry> nodes = new HashSet<InternalBufferTypes.Entry>();
        for (InternalBufferTypes.Entry entry : this.entries.values()) {
            if (entry.getId().equals(deletedId) || entry.getId().equals(relationId)) {
                deletedEntries.add(entry);
                deletedEntities.add(entry.getEntity());
                continue;
            }
            if (!entry.getId().equals(nodeId)) continue;
            nodes.add(entry);
        }
        for (InternalBufferTypes.Entry entry : nodes) {
            ((INodePattern)entry.getPattern()).deleteRelations(entry.getEntity(), deletedEntities);
        }
        for (InternalBufferTypes.Entry entry : deletedEntries) {
            this.removeEntry(entry);
            entry.getPattern().callMethod(PostDelete.class, entry.getEntity(), new Object[0]);
        }
    }
}

