/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.annotations;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.runeduniverse.lib.rogm.annotations.Converter;

public interface IConverter<T extends Serializable> {
    public static final Map<Class<?>, IConverter<?>> converter = new HashMap();

    public T convert(String var1);

    public String convert(T var1);

    default public String toProperty(Serializable id) {
        return this.convert(id);
    }

    public static IConverter<?> createConverter(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        IConverter conv = converter.get(clazz);
        if (conv != null) {
            return conv;
        }
        conv = (IConverter)clazz.newInstance();
        converter.put(clazz, conv);
        return conv;
    }

    public static IConverter<?> createConverter(Converter anno, Class<?> type) throws Exception {
        if (anno != null && anno.converter() != UnSet.class) {
            return (IConverter)anno.converter().newInstance();
        }
        switch (type.getName()) {
            case "java.lang.Short": {
                return IConverter.createConverter(ShortConverter.class);
            }
            case "java.lang.Integer": {
                return IConverter.createConverter(IntegerConverter.class);
            }
            case "java.lang.Long": {
                return IConverter.createConverter(LongConverter.class);
            }
            case "java.util.UUID": {
                return IConverter.createConverter(UUIDConverter.class);
            }
            case "java.lang.String": {
                return IConverter.createConverter(StringConverter.class);
            }
        }
        throw new Exception("No Converter for Class<" + type + "> defined!");
    }

    public static IConverter<?> validate(IConverter<?> converter) {
        if (converter == null) {
            return new UnSet();
        }
        return converter;
    }

    public static class UUIDConverter
    implements IConverter<UUID> {
        @Override
        public UUID convert(String serial) {
            return UUID.fromString(serial);
        }

        @Override
        public String convert(UUID id) {
            return id.toString();
        }
    }

    public static class LongConverter
    implements IConverter<Long> {
        @Override
        public Long convert(String serial) {
            return Long.parseLong(serial);
        }

        @Override
        public String convert(Long id) {
            return Long.toString(id);
        }
    }

    public static class IntegerConverter
    implements IConverter<Integer> {
        @Override
        public Integer convert(String serial) {
            return Integer.parseInt(serial);
        }

        @Override
        public String convert(Integer id) {
            return Integer.toString(id);
        }
    }

    public static class ShortConverter
    implements IConverter<Short> {
        @Override
        public Short convert(String serial) {
            return Short.parseShort(serial);
        }

        @Override
        public String convert(Short id) {
            return Short.toString(id);
        }
    }

    public static class StringConverter
    implements IConverter<String> {
        @Override
        public String convert(String serial) {
            return serial;
        }
    }

    public static class UnSet
    implements IConverter<Serializable> {
        @Override
        public Serializable convert(String serial) {
            return null;
        }

        @Override
        public String convert(Serializable id) {
            return null;
        }
    }
}

