/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm;

import java.io.Serializable;
import java.util.Collection;
import net.runeduniverse.lib.rogm.Configuration;
import net.runeduniverse.lib.rogm.pipeline.DatabasePipelineFactory;
import net.runeduniverse.lib.rogm.pipeline.Pipeline;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;

public interface Session
extends AutoCloseable {
    public boolean isConnected();

    public <T, ID extends Serializable> T load(Class<T> var1, ID var2);

    public <T, ID extends Serializable> T load(Class<T> var1, ID var2, Integer var3);

    public <T, ID extends Serializable> T loadLazy(Class<T> var1, ID var2);

    public <T> T load(IFilter var1);

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> var1, ID var2);

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> var1, ID var2, Integer var3);

    public <T, ID extends Serializable> Collection<T> loadAllLazy(Class<T> var1, ID var2);

    public <T> Collection<T> loadAll(Class<T> var1);

    public <T> Collection<T> loadAll(Class<T> var1, Integer var2);

    public <T> Collection<T> loadAllLazy(Class<T> var1);

    public <T> Collection<T> loadAll(IFilter var1);

    public void resolveLazyLoaded(Object var1);

    public void resolveLazyLoaded(Object var1, Integer var2);

    public void resolveAllLazyLoaded(Collection<? extends Object> var1);

    public void resolveAllLazyLoaded(Collection<? extends Object> var1, Integer var2);

    public void reload(Object var1);

    public void reload(Object var1, Integer var2);

    public void reloadAll(Collection<? extends Object> var1);

    public void reloadAll(Collection<? extends Object> var1, Integer var2);

    public void save(Object var1);

    public void save(Object var1, Integer var2);

    public void saveLazy(Object var1);

    public void saveAll(Collection<? extends Object> var1);

    public void saveAll(Collection<? extends Object> var1, Integer var2);

    public void saveAllLazy(Collection<? extends Object> var1);

    public void delete(Object var1);

    public void deleteAll(Collection<? extends Object> var1);

    public void unload(Object var1);

    public void unloadAll(Collection<? extends Object> var1);

    public QueryBuilder getQueryBuilder();

    public static Session create(Configuration cnf) throws Exception {
        return new Pipeline(new DatabasePipelineFactory(cnf)).buildSession();
    }
}

