/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.buffer.BasicBuffer;
import net.runeduniverse.lib.rogm.buffer.IBuffer;
import net.runeduniverse.lib.rogm.info.ConnectionInfo;
import net.runeduniverse.lib.rogm.info.PackageInfo;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.modules.PassiveModule;
import net.runeduniverse.lib.rogm.parser.Parser;

public class Configuration {
    protected final Set<String> pkgs = new HashSet<String>();
    protected final Set<ClassLoader> loader = new HashSet<ClassLoader>();
    protected final Set<PassiveModule> passiveModules = new HashSet<PassiveModule>();
    protected final Parser parser;
    protected final Language lang;
    protected final Module module;
    protected String uri;
    protected Logger logger = null;
    protected Level loggingLevel = null;
    protected String protocol;
    protected int port;
    protected String user;
    protected String password;
    protected IBuffer buffer = new BasicBuffer();

    public Configuration(Parser parser, Language lang, Module module, String uri) throws NullPointerException {
        this.parser = parser;
        this.lang = lang;
        this.module = module;
        this.passiveModules.add(this.module);
        this.uri = uri;
        this.validate();
    }

    public void validate() {
        if (this.parser == null) {
            throw new NullPointerException("Instance of net.runeduniverse.lib.rogm.parser.Parser is missing!");
        }
        if (this.lang == null) {
            throw new NullPointerException("Instance of net.runeduniverse.lib.rogm.lang.Language is missing!");
        }
        if (this.module == null) {
            throw new NullPointerException("Instance of net.runeduniverse.lib.rogm.modules.Module is missing!");
        }
    }

    public Configuration addPackage(String pkg) {
        this.pkgs.add(pkg);
        return this;
    }

    public Configuration addPackage(List<String> pkgs) {
        this.pkgs.addAll(pkgs);
        return this;
    }

    public Configuration addClassLoader(ClassLoader loader) {
        this.loader.add(loader);
        return this;
    }

    public Configuration addClassLoader(List<ClassLoader> loader) {
        this.loader.addAll(loader);
        return this;
    }

    public Configuration addPassiveModule(PassiveModule passivemodule) {
        this.passiveModules.add(passivemodule);
        return this;
    }

    public Configuration setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Level getLoggingLevel() {
        if (this.loggingLevel != null) {
            return this.loggingLevel;
        }
        return this.logger == null ? Level.INFO : this.logger.getLevel();
    }

    public PackageInfo getPackageInfo() {
        return new PackageInfo(this);
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(this);
    }

    public Set<String> getPkgs() {
        return this.pkgs;
    }

    public Set<ClassLoader> getLoader() {
        return this.loader;
    }

    public Set<PassiveModule> getPassiveModules() {
        return this.passiveModules;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Language getLang() {
        return this.lang;
    }

    public Module getModule() {
        return this.module;
    }

    public String getUri() {
        return this.uri;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBuffer(IBuffer buffer) {
        this.buffer = buffer;
    }
}

